function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useEffect, useRef } from "react";
import PropTypes from "prop-types";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import useLocale from "../../hooks/__internal__/useLocale";
import createGuid from "../../__internal__/utils/helpers/guid";
import Button from "../button";
import Box from "../box";
import Accordion from "./__internal__/accordion";
import { StyledTileSelectContainer, StyledTileSelect, StyledTileSelectInput, StyledTitleContainer, StyledTitle, StyledSubtitle, StyledAdornment, StyledDescription, StyledDeselectWrapper, StyledFooterWrapper, StyledFocusWrapper, StyledAccordionFooterWrapper } from "./tile-select.style";
import { filterStyledSystemMarginProps } from "../../style/utils";
const checkPropTypeIsNode = prop => typeof prop !== "string";
const TileSelect = /*#__PURE__*/React.forwardRef(({
  onChange,
  onBlur,
  onFocus,
  value,
  name,
  checked = false,
  className,
  disabled,
  title,
  subtitle,
  description,
  titleAdornment,
  type = "checkbox",
  id,
  customActionButton,
  actionButtonAdornment,
  footer,
  prefixAdornment,
  additionalInformation,
  accordionContent,
  accordionControl,
  accordionExpanded,
  ...rest
}, ref) => {
  const l = useLocale();
  const [hasFocus, setHasFocus] = useState(false);
  const handleDeselect = () => onChange?.({
    target: {
      ...(name && {
        name
      }),
      ...(id && {
        id
      }),
      value: null,
      checked: false
    }
  });
  const renderActionButton = () => /*#__PURE__*/React.createElement(StyledDeselectWrapper, {
    hasActionAdornment: !!actionButtonAdornment
  }, customActionButton && customActionButton(handleDeselect), !customActionButton && checked && /*#__PURE__*/React.createElement(Button, {
    buttonType: "tertiary",
    size: "small",
    disabled: disabled,
    onClick: handleDeselect
  }, l.tileSelect.deselect()), actionButtonAdornment);
  useEffect(() => {
    if (disabled && hasFocus) {
      setHasFocus(false);
    }
  }, [disabled, hasFocus]);
  const guid = useRef(createGuid());
  const contentId = `AccordionContent_${guid.current}`;
  const controlId = `AccordionControl_${guid.current}`;
  return /*#__PURE__*/React.createElement(StyledTileSelectContainer, _extends({
    checked: checked,
    className: className,
    disabled: disabled
  }, tagComponent("tile-select", rest), filterStyledSystemMarginProps(rest)), /*#__PURE__*/React.createElement(StyledFocusWrapper, {
    hasFocus: hasFocus,
    checked: checked
  }, /*#__PURE__*/React.createElement(StyledTileSelectInput, _extends({
    onChange: onChange,
    onBlur: ev => {
      setHasFocus(false);
      onBlur?.(ev);
    },
    onFocus: ev => {
      setHasFocus(true);
      onFocus?.(ev);
    },
    checked: checked,
    name: name,
    type: type,
    value: value,
    disabled: disabled,
    "aria-checked": checked,
    id: id,
    ref: ref
  }, rest)), /*#__PURE__*/React.createElement(StyledTileSelect, {
    disabled: disabled,
    checked: checked
  }, /*#__PURE__*/React.createElement(Box, {
    display: "flex",
    justifyContent: "space-between",
    flexDirection: "row-reverse"
  }, (customActionButton || checked) && renderActionButton(), /*#__PURE__*/React.createElement(Box, {
    flexGrow: 1
  }, /*#__PURE__*/React.createElement(StyledTitleContainer, null, title && /*#__PURE__*/React.createElement(StyledTitle, {
    as: checkPropTypeIsNode(title) ? "div" : undefined
  }, title), subtitle && /*#__PURE__*/React.createElement(StyledSubtitle, {
    as: checkPropTypeIsNode(subtitle) ? "div" : undefined
  }, subtitle), titleAdornment && /*#__PURE__*/React.createElement(StyledAdornment, {
    hasAdditionalInformation: !!additionalInformation
  }, titleAdornment && /*#__PURE__*/React.createElement("div", null, titleAdornment))), additionalInformation && /*#__PURE__*/React.createElement("div", null, additionalInformation), /*#__PURE__*/React.createElement(StyledDescription, {
    as: checkPropTypeIsNode(description) ? "div" : undefined
  }, description), footer && /*#__PURE__*/React.createElement(StyledFooterWrapper, null, footer), accordionContent && accordionControl && /*#__PURE__*/React.createElement(StyledAccordionFooterWrapper, {
    accordionExpanded: accordionExpanded
  }, accordionControl(controlId, contentId))), prefixAdornment && /*#__PURE__*/React.createElement(Box, {
    "data-element": "prefix-adornment",
    mr: 3,
    opacity: disabled ? "0.3" : undefined
  }, prefixAdornment))), accordionContent && /*#__PURE__*/React.createElement(Accordion, {
    contentId: contentId,
    controlId: controlId,
    expanded: accordionExpanded
  }, accordionContent)));
});
if (process.env.NODE_ENV !== "production") {
  TileSelect.propTypes = {
    "accordionContent": PropTypes.node,
    "accordionControl": PropTypes.func,
    "accordionExpanded": PropTypes.bool,
    "actionButtonAdornment": PropTypes.node,
    "additionalInformation": PropTypes.node,
    "checked": PropTypes.bool,
    "className": PropTypes.string,
    "customActionButton": PropTypes.func,
    "description": PropTypes.node,
    "disabled": PropTypes.bool,
    "footer": PropTypes.node,
    "id": PropTypes.string,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string,
    "onBlur": PropTypes.func,
    "onChange": PropTypes.func,
    "onFocus": PropTypes.func,
    "prefixAdornment": PropTypes.node,
    "subtitle": PropTypes.node,
    "title": PropTypes.node,
    "titleAdornment": PropTypes.node,
    "type": PropTypes.oneOf(["checkbox", "radio"]),
    "value": PropTypes.string
  };
}
TileSelect.displayName = "TileSelect";
export default TileSelect;