function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
import RadioButtonMapper from "../../../__internal__/radio-button-mapper/radio-button-mapper.component";
import { StyledTileSelectFieldset, StyledGroupDescription } from "../tile-select.style";
import { filterStyledSystemMarginProps } from "../../../style/utils";
export const TileSelectGroup = ({
  children,
  name,
  legend,
  description,
  onChange,
  onBlur,
  value,
  multiSelect = false,
  ...rest
}) => {
  let tiles;
  if (multiSelect) {
    tiles = children;
  } else {
    tiles = /*#__PURE__*/React.createElement(RadioButtonMapper, {
      name: name,
      onBlur: onBlur,
      onChange: onChange,
      value: value
    }, React.Children.map(children, child => {
      if ( /*#__PURE__*/React.isValidElement(child)) {
        return /*#__PURE__*/React.cloneElement(child, {
          type: "radio"
        });
      }
      return child;
    }));
  }
  return /*#__PURE__*/React.createElement(StyledTileSelectFieldset, _extends({
    legend: legend
  }, tagComponent("tile-select-group", rest), {
    multiSelect: multiSelect
  }, filterStyledSystemMarginProps(rest)), description && /*#__PURE__*/React.createElement(StyledGroupDescription, {
    "data-element": "tile-select-group-description"
  }, description), tiles);
};
export default TileSelectGroup;