import React from "react";
import { MarginProps } from "styled-system";
import { TileSelectDeselectEvent } from "../tile-select.component";
export interface TileSelectGroupProps extends MarginProps {
    /** The TileSelect components to be rendered in the group */
    children: React.ReactNode;
    /** The content for the TileSelectGroup Legend */
    legend?: string;
    /** Description to be rendered below the legend */
    description?: string;
    /** The currently selected value - only for single select mode. */
    value?: string | null;
    /** The name to apply to the input - only for single select mode. */
    name: string;
    /** A callback triggered when one of tiles is selected - only for single select mode. */
    onChange?: (ev: React.ChangeEvent<HTMLInputElement> | TileSelectDeselectEvent) => void;
    /** A callback triggered when one of tiles is blurred - only for single select mode. */
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** When passed as true TileSelectGroup serves only visual purpose */
    /** It wraps TileSelects in fieldset element and renders the legend and description props content */
    /** onChange, onBlur, value, checked and name props are meant to be passed individually on each of the TileSelects */
    multiSelect?: boolean;
}
export declare const TileSelectGroup: ({ children, name, legend, description, onChange, onBlur, value, multiSelect, ...rest }: TileSelectGroupProps) => React.JSX.Element;
export default TileSelectGroup;
