import React, { useRef, useState } from "react";
import PropTypes from "prop-types";
import { StyledContentContainer, StyledContent } from "./accordion.style";
import useResizeObserver from "../../../../hooks/__internal__/useResizeObserver";
const Accordion = ({
  children,
  expanded,
  contentId,
  controlId
}) => {
  const [contentHeight, setContentHeight] = useState(0);
  const contentRef = useRef(null);
  useResizeObserver(contentRef, () => {
    // istanbul ignore else
    if (contentRef.current) {
      setContentHeight(contentRef.current.scrollHeight);
    }
  });
  return /*#__PURE__*/React.createElement(StyledContentContainer, {
    "aria-expanded": expanded,
    isExpanded: expanded,
    maxHeight: contentHeight
  }, /*#__PURE__*/React.createElement(StyledContent, {
    role: "region",
    "data-element": "tile-select-accordion-content",
    ref: contentRef,
    id: contentId,
    "aria-labelledby": controlId
  }, children));
};
export default Accordion;