import React from "react";
import { MarginProps } from "styled-system";
import { CommonInputProps } from "../../__internal__/input";
import { ValidationProps } from "../../__internal__/validations";
import { IconType } from "../icon";
export declare const ALIGN_DEFAULT = "left";
export declare const SIZE_DEFAULT = "medium";
export declare const LABEL_WIDTH_DEFAULT = 30;
export declare const LABEL_VALIDATION_DEFAULT = false;
export interface CommonTextboxProps extends ValidationProps, MarginProps, Omit<CommonInputProps, "size" | "inputBorderRadius"> {
    /** Prop to specify the aria-labelledby property of the component */
    "aria-labelledby"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-component"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** Breakpoint for adaptive label (inline labels change to top aligned). Enables the adaptive behaviour when set */
    adaptiveLabelBreakpoint?: number;
    /** Integer to determine a timeout for the deferred callback */
    deferTimeout?: number;
    /** A hint string rendered before the input but after the label. Intended to describe the purpose or content of the input. */
    inputHint?: string;
    /** Help content to be displayed under an input */
    fieldHelp?: React.ReactNode;
    /**
     * An optional alternative for props.value, this is useful if the
     * real value is an ID but you want to show a human-readable version.
     */
    formattedValue?: string;
    /**
     * Unique identifier for the input.
     * Label id will be based on it, using following pattern: [id]-label.
     * Will use a randomly generated GUID if none is provided.
     */
    id?: string;
    /** Type of the icon that will be rendered next to the input */
    inputIcon?: IconType;
    /** Optional handler for click event on Textbox icon */
    iconOnClick?: (ev: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>) => void;
    /** Optional handler for mouse down event on Textbox icon */
    iconOnMouseDown?: (ev: React.MouseEvent<HTMLElement>) => void;
    /** Overrides the default tabindex of the component */
    iconTabIndex?: number;
    /** The width of the input as a percentage */
    inputWidth?: number;
    /**
     * Prop for specifying the max width of the input.
     * Leaving the `maxWidth` prop with no value will default the width to '100%'
     */
    maxWidth?: string;
    /** Additional child elements to display before the input */
    leftChildren?: React.ReactNode;
    /** Label content */
    label?: string;
    /** Inline label alignment */
    labelAlign?: "left" | "right";
    /** [Legacy] Text applied to label help tooltip. When opted into new design validations
     * it will render as a hint above the input, unless an `inputHint`
     * prop is also passed
     */
    labelHelp?: React.ReactNode;
    /** When true label is inline */
    labelInline?: boolean;
    /** Spacing between label and a field for inline label, given number will be multiplied by base spacing unit (8) */
    labelSpacing?: 1 | 2;
    /** Label width */
    labelWidth?: number;
    /** Specify a callback triggered on change */
    onChange?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
    /** Deferred callback to be called after the onChange event */
    onChangeDeferred?: () => void;
    /** Specify a callback triggered on click */
    onClick?: (ev: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>) => void;
    /** Event handler for the focus event */
    onFocus?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Event handler for the blur event */
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Event handler for the mouse down event */
    onMouseDown?: (ev: React.MouseEvent<HTMLElement>) => void;
    /** Emphasized part of the displayed text */
    prefix?: string;
    /** Reverses label and input display */
    reverse?: boolean;
    /** Size of an input */
    size?: "small" | "medium" | "large";
    /** When true, validation icon will be placed on label instead of being placed on the input */
    validationOnLabel?: boolean;
    /** Overrides the default tooltip position */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** Aria label for rendered help component */
    helpAriaLabel?: string;
    /** Flag to configure component as optional. */
    isOptional?: boolean;
}
export interface TextboxProps extends CommonTextboxProps {
    /** Content to be rendered next to the input */
    children?: React.ReactNode;
    /** Container for DatePicker or SelectList components */
    positionedChildren?: React.ReactNode;
    /** Character limit of the textarea */
    characterLimit?: number;
}
export declare const Textbox: React.ForwardRefExoticComponent<TextboxProps & React.RefAttributes<HTMLInputElement>>;
export default Textbox;
