import { EditorState, ContentBlock, DraftInlineStyle, ContentState } from "draft-js";
import { BlockType, InlineStyleType } from "../../types";
export declare const computeBlockType: (char: string, type: string) => "unordered-list-item" | "ordered-list-item" | "unstyled";
export declare const resetBlockType: (value: EditorState, newType?: BlockType | "unstyled") => EditorState;
export declare function blockStyleFn(block: ContentBlock): "" | "text-editor-block-unordered" | "text-editor-block-ordered";
export declare const getDecoratedValue: (value: EditorState) => EditorState;
export declare const getContent: (value: EditorState) => ContentState;
export declare const getSelection: (value: EditorState) => Draft.Model.ImmutableData.SelectionState;
export declare const getContentInfo: (value: EditorState) => {
    content: ContentState;
    currentBlock: ContentBlock;
    blockType: string;
    blockLength: number;
    blockText: string;
    blockMap: Draft.Model.ImmutableData.BlockMap;
};
export declare const getSelectionInfo: (value: EditorState) => {
    selection: Draft.Model.ImmutableData.SelectionState;
    startKey: string;
    endKey: string;
    startOffset: number;
    endOffset: number;
};
export declare const moveSelectionToEnd: (value: EditorState) => EditorState;
export declare const getSelectedLength: (value: EditorState) => number;
export declare function hasBlockStyle(value: EditorState, type: BlockType): boolean;
export declare function hasInlineStyle(value: EditorState, style: InlineStyleType): boolean;
export declare function isASCIIChar(str: string): boolean;
export declare function replaceText(editorState: EditorState, text: string, inlineStyle: DraftInlineStyle): EditorState;
