import React from "react";
import type { InlineStyleType, BlockType } from "../../types";
export interface ToolbarProps {
    /** Used to override the active status of the inline controls */
    activeControls: Record<InlineStyleType | BlockType, boolean>;
    /** Flag to trigger control focusing */
    canFocus?: boolean;
    /** Callback to handle setting the inline styles */
    setInlineStyle: (ev: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>, inlineType: InlineStyleType) => void;
    /** Callback to handle setting the block styles */
    setBlockStyle: (ev: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>, blockType: BlockType) => void;
    /** Additional elements to be rendered in the Toolbar, e.g. Save and Cancel Button */
    toolbarElements?: React.ReactNode;
}
declare const Toolbar: ({ activeControls, canFocus, toolbarElements, setBlockStyle, setInlineStyle, }: ToolbarProps) => React.JSX.Element;
export default Toolbar;
