function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import StyledToolbarButton from "./toolbar-button.style";
const ToolbarButton = /*#__PURE__*/React.forwardRef(({
  onKeyDown,
  onMouseDown,
  activated,
  ariaLabel,
  tabbable,
  children,
  onMouseOver,
  onMouseLeave,
  onFocus,
  onBlur
}, ref) => {
  return /*#__PURE__*/React.createElement(StyledToolbarButton, _extends({
    "data-component": "text-editor-toolbar-button",
    ref: ref,
    onKeyDown: onKeyDown,
    onMouseDown: onMouseDown,
    isActive: activated,
    "aria-label": ariaLabel
  }, !tabbable && {
    tabIndex: -1
  }, {
    onMouseOver: onMouseOver,
    onMouseLeave: onMouseLeave,
    onFocus: onFocus,
    onBlur: onBlur
  }), children);
});
if (process.env.NODE_ENV !== "production") {
  ToolbarButton.propTypes = {
    "activated": PropTypes.bool,
    "ariaLabel": PropTypes.string.isRequired,
    "children": PropTypes.node,
    "onBlur": PropTypes.func,
    "onFocus": PropTypes.func,
    "onKeyDown": PropTypes.func.isRequired,
    "onMouseDown": PropTypes.func.isRequired,
    "onMouseLeave": PropTypes.func,
    "onMouseOver": PropTypes.func,
    "tabbable": PropTypes.bool
  };
}
export { ToolbarButton };
ToolbarButton.displayName = "ToolbarButton";
export default ToolbarButton;