import React from "react";
export interface ToolbarButtonProps {
    /** Accessibility label for a button */
    ariaLabel: string;
    /** The children for the button */
    children: React.ReactNode;
    /** Used to control the button's active status */
    activated?: boolean;
    /** Callback to handle any keydown events on a button */
    onKeyDown: (ev: React.KeyboardEvent<HTMLButtonElement>) => void;
    /** Callback to handle any mousedown events on a button */
    onMouseDown: (ev: React.MouseEvent<HTMLButtonElement>) => void;
    /** Callback to handle any mouseover events on a button */
    onMouseOver?: (ev: React.MouseEvent<HTMLButtonElement>) => void;
    /** Callback to handle any mouseleave events on a button */
    onMouseLeave?: (ev: React.MouseEvent<HTMLButtonElement>) => void;
    /** Callback to handle any focus events on a button */
    onFocus?: (ev: React.FocusEvent<HTMLButtonElement>) => void;
    /** Callback to handle any blur events on a button */
    onBlur?: (ev: React.FocusEvent<HTMLButtonElement>) => void;
    /** Controls whether the button can be tabbed to */
    tabbable?: boolean;
}
export declare const ToolbarButton: React.ForwardRefExoticComponent<ToolbarButtonProps & React.RefAttributes<HTMLButtonElement>>;
export default ToolbarButton;
