function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useEffect } from "react";
import PropTypes from "prop-types";
import StyledLink from "./editor-link.style";
import { EditorContext } from "../../text-editor.component";
const EditorLink = ({
  children,
  contentState,
  entityKey,
  ...rest
}) => {
  const url = !!contentState && !!entityKey ? contentState.getEntity(entityKey).getData() : children[0].props.text;
  const buildValidUrl = () => {
    const candidateUrl = url.url || url;
    const regex = /(http:\/\/|https:\/\/)+/g;
    return regex.test(candidateUrl) ? candidateUrl : `https://${candidateUrl}`;
  };
  const validUrl = buildValidUrl();
  const {
    onLinkAdded,
    editMode
  } = useContext(EditorContext);
  useEffect(() => {
    if (onLinkAdded) {
      onLinkAdded(validUrl);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [validUrl]);
  return /*#__PURE__*/React.createElement(StyledLink, _extends({
    href: !editMode ? validUrl : undefined,
    "aria-label": !editMode ? validUrl : undefined,
    target: "_blank",
    rel: "noopener noreferrer"
  }, rest), children);
};
export default EditorLink;