import styled, { css } from "styled-components";
import { margin } from "styled-system";
import BaseTheme from "../../style/themes/base";
import { StyledTabsHeaderWrapper } from "./__internal__/tabs-header/tabs-header.style";
import StyledTab from "./tab/tab.style";
const StyledTabs = styled.div`
  ${({
  position,
  isInSidebar,
  headerWidth
}) => css`
    color: var(--colorsActionMinorYin090);

    ${position === "left" && css`
      ${headerWidth && css`
        ${StyledTabsHeaderWrapper} {
          width: ${headerWidth};
        }

        ${StyledTab} {
          width: auto;
        }
      `}

      ${!isInSidebar && css`
        display: flex;
        width: 100%;
      `}

      ${isInSidebar && css`
        width: 99%;
      `}
    `}
  `}

  ${margin}
`;
StyledTabs.defaultProps = {
  theme: BaseTheme
};
export default StyledTabs;