import styled, { css } from "styled-components";
import { padding } from "styled-system";
import BaseTheme from "../../../style/themes/base";
const StyledTab = styled.div`
  display: none;

  ${({
  isTabSelected,
  position = "top"
}) => isTabSelected && css`
      display: block;

      ${position === "left" && css`
        margin-left: -6px;
        margin-top: var(--spacing075);
        width: calc(80% + var(--spacing075));
      `}

      ${padding}
    `}
`;
StyledTab.defaultProps = {
  theme: BaseTheme
};
export default StyledTab;