function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useEffect, useState } from "react";
import PropTypes from "prop-types";
import StyledTab from "./tab.style";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
const TabContext = /*#__PURE__*/React.createContext({});
export const Tab = ({
  ariaLabelledby,
  className,
  children,
  isTabSelected,
  position = "top",
  role = "tabpanel",
  tabId,
  updateErrors,
  updateWarnings,
  updateInfos,
  href,
  // title is destructured purely to NOT spread it as part of rest to the underlying HTML element.
  // Both this and titleProps are used as part of child.props inside Tabs component
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  title,
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  titleProps,
  ...rest
}) => {
  const [tabErrors, setTabErrors] = useState({});
  const [tabWarnings, setTabWarnings] = useState({});
  const [tabInfos, setTabInfos] = useState({});
  const setError = useCallback((childId, error) => {
    setTabErrors(state => state[childId] !== error ? {
      ...state,
      [childId]: error
    } : state);
  }, []);
  const setWarning = useCallback((childId, warning) => {
    setTabWarnings(state => state[childId] !== warning ? {
      ...state,
      [childId]: warning
    } : state);
  }, []);
  const setInfo = useCallback((childId, info) => {
    setTabInfos(state => state[childId] !== info ? {
      ...state,
      [childId]: info
    } : state);
  }, []);
  useEffect(() => {
    if (updateErrors) {
      updateErrors(tabId, tabErrors);
    }
  }, [tabId, tabErrors, updateErrors]);
  useEffect(() => {
    if (updateWarnings) {
      updateWarnings(tabId, tabWarnings);
    }
  }, [tabId, tabWarnings, updateWarnings]);
  useEffect(() => {
    if (updateInfos) {
      updateInfos(tabId, tabInfos);
    }
  }, [tabId, tabInfos, updateInfos]);
  return /*#__PURE__*/React.createElement(TabContext.Provider, {
    value: {
      setError,
      setWarning,
      setInfo
    }
  }, /*#__PURE__*/React.createElement(StyledTab, _extends({
    className: className,
    role: role,
    isTabSelected: isTabSelected,
    "aria-labelledby": ariaLabelledby,
    position: position
  }, tagComponent("tab", rest), rest), !href && children));
};
export { TabContext };
export default Tab;