function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef, useState } from "react";
import PropTypes from "prop-types";
import { StyledTabTitleButton, StyledTabTitleLink, StyledTitleContent, StyledLayoutWrapper, StyledSelectedIndicator } from "./tab-title.style";
import tagComponent from "../../../../__internal__/utils/helpers/tags/tags";
import ValidationIcon from "../../../../__internal__/validations/validation-icon.component";
import Icon from "../../../icon";
import Events from "../../../../__internal__/utils/helpers/events";
import { TooltipProvider } from "../../../../__internal__/tooltip-provider";
export const TabTitleContext = /*#__PURE__*/React.createContext({});
const TabTitle = /*#__PURE__*/React.forwardRef(({
  isTabSelected,
  dataTabId,
  "data-role": dataRole,
  title,
  position,
  error,
  warning,
  info,
  size = "default",
  onClick,
  titlePosition = "before",
  siblings,
  errorMessage = "",
  warningMessage = "",
  infoMessage = "",
  borders,
  alternateStyling = false,
  noLeftBorder = false,
  noRightBorder = false,
  customLayout,
  isInSidebar,
  href,
  onKeyDown,
  align,
  tabIndex,
  ...tabTitleProps
}, ref) => {
  const isHref = !!href;
  const hasAlternateStyling = alternateStyling || isInSidebar;
  const hasFailedValidation = error || warning || info;
  const [shouldShowTooltip, setShouldShowTooltip] = useState(false);
  const hasHover = useRef(false);
  const showTooltip = () => {
    setShouldShowTooltip(true);
  };
  const hideTooltip = () => {
    if (typeof ref === "object" && ref?.current !== document.activeElement && !hasHover.current) {
      setShouldShowTooltip(false);
    }
  };
  const handleKeyDown = ev => {
    ev.stopPropagation();
    if (href && Events.isEnterOrSpaceKey(ev)) {
      return window.open(href, "_blank");
    }
    return onKeyDown(ev);
  };
  const handleClick = ev => {
    ev.preventDefault();
    const customEvent = {
      ...ev,
      target: {
        ...ev.target,
        dataset: {
          tabid: dataTabId
        }
      }
    };
    if (href) {
      onClick(customEvent);
      return window.open(href, "_blank");
    }

    // safari does not focus buttons by default
    // istanbul ignore else (ref is always passed as an object from Tabs component, if was only added to satisfy Typescript compiler)
    if (typeof ref === "object") {
      ref?.current?.focus();
    }
    return onClick(customEvent);
  };
  const renderContent = () => {
    if (customLayout) {
      return /*#__PURE__*/React.createElement(StyledLayoutWrapper, {
        hasCustomLayout: true
      }, customLayout);
    }
    if (!siblings) {
      return title;
    }
    const titleText = /*#__PURE__*/React.createElement(React.Fragment, {
      key: "title"
    }, title);
    const titleSiblings = /*#__PURE__*/React.createElement(StyledLayoutWrapper, {
      titlePosition: titlePosition,
      key: "title-siblings"
    }, React.Children.toArray(siblings).map(child => {
      // istanbul ignore next
      if (! /*#__PURE__*/React.isValidElement(child)) {
        return child;
      }
      return /*#__PURE__*/React.cloneElement(child, {
        ...child.props,
        onClick: handleClick
      });
    }));
    return titlePosition === "before" ? [titleText, titleSiblings] : [titleSiblings, titleText];
  };
  const titleChildren = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(StyledTitleContent, {
    error: error,
    warning: warning,
    info: info,
    position: position,
    size: size,
    noLeftBorder: noLeftBorder,
    noRightBorder: noRightBorder,
    borders: borders,
    hasSiblings: !!siblings,
    isTabSelected: isTabSelected,
    hasCustomLayout: !!customLayout,
    alternateStyling: hasAlternateStyling,
    align: align,
    hasHref: !!href
  }, renderContent(), isHref && /*#__PURE__*/React.createElement(Icon, {
    type: "link"
  }), hasFailedValidation && /*#__PURE__*/React.createElement(StyledLayoutWrapper, {
    position: position,
    hasCustomSibling: !!customLayout
  }, error && /*#__PURE__*/React.createElement(ValidationIcon, {
    tooltipPosition: "top",
    error: errorMessage
  }), !error && warning && /*#__PURE__*/React.createElement(ValidationIcon, {
    tooltipPosition: "top",
    warning: warningMessage
  }), !warning && !error && info && /*#__PURE__*/React.createElement(ValidationIcon, {
    tooltipPosition: "top",
    info: infoMessage
  }))), !(hasFailedValidation || hasAlternateStyling) && isTabSelected && /*#__PURE__*/React.createElement(StyledSelectedIndicator, {
    "data-element": "tab-selected-indicator",
    position: position
  }));
  const titleWrapperProps = {
    "aria-selected": isTabSelected,
    "data-element": "select-tab",
    "data-tabid": dataTabId,
    "data-role": dataRole,
    role: "tab",
    position,
    isTabSelected,
    error,
    warning,
    info,
    noRightBorder,
    noLeftBorder,
    alternateStyling: alternateStyling || isInSidebar,
    borders,
    isInSidebar,
    tabIndex,
    ...tabTitleProps,
    ...tagComponent("tab-header", tabTitleProps),
    onKeyDown: handleKeyDown,
    onClick: handleClick,
    size,
    onMouseOver: () => {
      hasHover.current = true;
      showTooltip();
    },
    onMouseLeave: () => {
      hasHover.current = false;
      hideTooltip();
    },
    onFocus: showTooltip,
    onBlur: hideTooltip
  };
  const tabTitle = isHref ? /*#__PURE__*/React.createElement(StyledTabTitleLink, _extends({}, titleWrapperProps, {
    ref: ref,
    href: href,
    target: "_blank"
  }), titleChildren) : /*#__PURE__*/React.createElement(StyledTabTitleButton, _extends({}, titleWrapperProps, {
    type: "button",
    ref: ref
  }), titleChildren);
  return /*#__PURE__*/React.createElement(TooltipProvider, {
    tooltipVisible: shouldShowTooltip
  }, /*#__PURE__*/React.createElement(TabTitleContext.Provider, {
    value: {
      isInTab: true
    }
  }, tabTitle));
});
if (process.env.NODE_ENV !== "production") {
  TabTitle.propTypes = {
    "align": PropTypes.oneOf(["left", "right"]),
    "alternateStyling": PropTypes.bool,
    "borders": PropTypes.bool,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "customLayout": PropTypes.node,
    "data-role": PropTypes.string,
    "dataTabId": PropTypes.string,
    "error": PropTypes.bool,
    "errorMessage": PropTypes.string,
    "href": PropTypes.string,
    "id": PropTypes.string,
    "info": PropTypes.bool,
    "infoMessage": PropTypes.string,
    "isInSidebar": PropTypes.bool,
    "isTabSelected": PropTypes.bool,
    "noLeftBorder": PropTypes.bool,
    "noRightBorder": PropTypes.bool,
    "onClick": PropTypes.func.isRequired,
    "onKeyDown": PropTypes.func.isRequired,
    "position": PropTypes.oneOf(["left", "top"]),
    "siblings": PropTypes.node,
    "size": PropTypes.oneOf(["default", "large"]),
    "tabIndex": PropTypes.number,
    "title": PropTypes.string,
    "titlePosition": PropTypes.oneOf(["after", "before"]),
    "warning": PropTypes.bool,
    "warningMessage": PropTypes.string
  };
}
TabTitle.displayName = "TabTitle";
export default TabTitle;