function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import Logger from "../../__internal__/utils/logger";
import StyledStepSequence from "./step-sequence.style";
export const StepSequenceContext = /*#__PURE__*/React.createContext({
  orientation: "horizontal"
});
let deprecateWarnTriggered = false;
export const StepSequence = ({
  children,
  orientation = "horizontal",
  ...props
}) => {
  if (!deprecateWarnTriggered) {
    deprecateWarnTriggered = true;
    Logger.deprecate("The `StepSequence` component is deprecated and will soon be removed," + " please use the `StepFlow` component instead.");
  }
  return /*#__PURE__*/React.createElement(StyledStepSequence, _extends({
    "data-component": "step-sequence",
    orientation: orientation,
    p: 0
  }, props), /*#__PURE__*/React.createElement(StepSequenceContext.Provider, {
    value: {
      orientation
    }
  }, children));
};
export default StepSequence;