function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import { StyledStepSequenceItem, StyledStepSequenceItemContent, StyledStepSequenceItemIndicator, StyledStepSequenceItemHiddenLabel } from "./step-sequence-item.style";
import Icon from "../../icon";
import { StepSequenceContext } from "../step-sequence.component";
export const StepSequenceItem = ({
  hideIndicator = false,
  indicator,
  status = "incomplete",
  hiddenCompleteLabel,
  hiddenCurrentLabel,
  children,
  ariaLabel,
  ...rest
}) => {
  const {
    orientation
  } = useContext(StepSequenceContext);
  const indicatorText = () => {
    return !hideIndicator ? /*#__PURE__*/React.createElement(StyledStepSequenceItemIndicator, null, indicator) : null;
  };
  const icon = () => status === "complete" ? /*#__PURE__*/React.createElement(Icon, {
    type: "tick"
  }) : indicatorText();
  const hiddenLabel = () => {
    if (hiddenCompleteLabel && status === "complete") {
      return /*#__PURE__*/React.createElement(StyledStepSequenceItemHiddenLabel, null, hiddenCompleteLabel);
    }
    if (hiddenCurrentLabel && status === "current") {
      return /*#__PURE__*/React.createElement(StyledStepSequenceItemHiddenLabel, null, hiddenCurrentLabel);
    }
    return null;
  };
  return /*#__PURE__*/React.createElement(StyledStepSequenceItem, _extends({
    "data-component": "step-sequence-item",
    orientation: orientation,
    status: status,
    key: `step-seq-item-${indicator}`,
    "aria-label": ariaLabel
  }, rest), hiddenLabel(), /*#__PURE__*/React.createElement(StyledStepSequenceItemContent, null, icon(), /*#__PURE__*/React.createElement("span", null, children)));
};
export default StepSequenceItem;