function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useImperativeHandle, useRef, forwardRef } from "react";
import PropTypes from "prop-types";
import Icon from "../icon";
import IconButton from "../icon-button";
import { StyledStepFlow, StyledStepContent, StyledStepContentText, StyledStepLabelAndProgress, StyledProgressIndicatorBar, StyledProgressIndicator, StyledTitleFocusWrapper } from "./step-flow.style";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import Typography from "../typography";
import useLocale from "../../hooks/__internal__/useLocale";
const StepFlow = /*#__PURE__*/forwardRef(({
  category,
  title,
  titleVariant,
  totalSteps,
  currentStep,
  showProgressIndicator = false,
  showCloseIcon = false,
  onDismiss,
  ...rest
}, ref) => {
  const totalStepsArray = Array.from({
    length: totalSteps
  }, (_, index) => index + 1);
  const validatedCurrentStep = currentStep > totalSteps ? totalSteps : currentStep;
  let currentStepWarnTriggered = false;
  let noRefWarnTriggered = false;

  /* eslint-disable no-console */
  if (!currentStepWarnTriggered && currentStep > totalSteps) {
    currentStepWarnTriggered = true;
    console.warn("[WARNING] The `currentStep` prop should not be higher than the `totalSteps`prop in `StepFlow`." + " Please ensure `currentStep`s value does not exceed that of `totalSteps`, in the meantime" + " we have set `currentStep` value to that of `totalSteps`, and all indicators have been marked as completed.");
  }
  if (!noRefWarnTriggered && !ref) {
    noRefWarnTriggered = true;
    console.warn("[WARNING] A `ref` should be provided to ensure focus is programmatically focused back to a title div," + " this ensures screen reader users are informed regarding any changes and can navigate back down the page.");
  }
  const progressIndicators = totalStepsArray.map(step => {
    const generateDataState = () => {
      if (step === validatedCurrentStep) {
        return "in-progress";
      }
      if (step < validatedCurrentStep) {
        return "is-completed";
      }
      return "not-completed";
    };
    return /*#__PURE__*/React.createElement(StyledProgressIndicator, {
      key: step,
      "aria-hidden": "true",
      "data-element": "progress-indicator",
      isCompleted: step < validatedCurrentStep,
      isInProgress: step === validatedCurrentStep,
      "data-state": generateDataState()
    }, "\xA0");
  });
  const locale = useLocale();
  const closeIcon = /*#__PURE__*/React.createElement(IconButton, {
    "data-element": "close",
    "aria-label": locale.stepFlow.closeIconAriaLabel?.(),
    onClick: onDismiss
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "close"
  }));
  const titleRef = useRef(null);
  useImperativeHandle(ref, () => ({
    focus() {
      titleRef.current?.focus();
    }
  }), []);
  const stepFlowTitle = /*#__PURE__*/React.createElement(StyledTitleFocusWrapper, {
    "data-element": "title-text-wrapper",
    tabIndex: -1,
    ref: titleRef
  }, /*#__PURE__*/React.createElement(Typography, {
    variant: titleVariant || "h1",
    "data-element": "title-text"
  }, /*#__PURE__*/React.createElement(Typography, {
    fontWeight: "900",
    fontSize: "var(--fontSizes600)",
    lineHeight: "var(--sizing375)",
    variant: "span",
    "aria-hidden": "true",
    "data-element": "visible-title-text"
  }, title), /*#__PURE__*/React.createElement(Typography, {
    variant: "span",
    "data-element": "visually-hidden-title-text",
    screenReaderOnly: true
  }, locale.stepFlow.screenReaderOnlyTitle(title, validatedCurrentStep, totalSteps, category))));
  const stepFlowLabel = /*#__PURE__*/React.createElement(Typography, {
    variant: "span",
    fontWeight: "400",
    fontSize: "var(--fontSizes200)",
    lineHeight: "var(--sizing300)",
    "data-element": "step-label",
    "aria-hidden": "true"
  }, locale.stepFlow.stepLabel(validatedCurrentStep, totalSteps));
  return /*#__PURE__*/React.createElement(StyledStepFlow, _extends({}, rest, tagComponent("step-flow", rest)), /*#__PURE__*/React.createElement(StyledStepContent, null, category ? /*#__PURE__*/React.createElement(StyledStepContentText, null, /*#__PURE__*/React.createElement(Typography, {
    fontWeight: "500",
    fontSize: "var(--fontSizes100)",
    lineHeight: "var(--sizing250)",
    variant: "span",
    "data-element": "category-text",
    "aria-hidden": "true"
  }, category), stepFlowTitle) : stepFlowTitle, showCloseIcon ? closeIcon : null), showProgressIndicator ? /*#__PURE__*/React.createElement(StyledStepLabelAndProgress, null, stepFlowLabel, /*#__PURE__*/React.createElement(StyledProgressIndicatorBar, {
    "data-element": "progress-indicator-bar"
  }, progressIndicators)) : stepFlowLabel);
});
if (process.env.NODE_ENV !== "production") {
  StepFlow.propTypes = {
    "category": PropTypes.string,
    "children": PropTypes.node,
    "currentStep": PropTypes.oneOf([1, 2, 3, 4, 5, 6, 7, 8]).isRequired,
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "onDismiss": PropTypes.func,
    "showCloseIcon": PropTypes.bool,
    "showProgressIndicator": PropTypes.bool,
    "title": PropTypes.string.isRequired,
    "titleVariant": PropTypes.oneOf(["h1", "h2"]),
    "totalSteps": PropTypes.oneOf([1, 2, 3, 4, 5, 6, 7, 8]).isRequired
  };
}
export { StepFlow };
export default StepFlow;