import React from "react";
import { MarginProps } from "styled-system";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
export declare type Steps = 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8;
export interface StepFlowProps extends MarginProps, TagProps {
    /** A category for the user journey.  */
    category?: string;
    /** The title of the current step.  */
    title: string;
    /** Set the variant of the internal 'Typography' component which contains the title.
     * However, despite the chosen variant the styling will always be overridden.
     */
    titleVariant?: "h1" | "h2";
    /** The total steps in the user journey.  */
    totalSteps: Steps;
    /**
     * The current step of the user journey. If the set `currentStep` is higher than
     * `totalSteps`the value of `currentStep` will be that of `totalSteps` instead.
     */
    currentStep: Steps;
    /** Determines if the progress indicator is shown. */
    showProgressIndicator?: boolean;
    /** Determines if the close icon button is shown */
    showCloseIcon?: boolean;
    /** function runs when user click dismiss button */
    onDismiss?: (e: React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>) => void;
}
export declare type StepFlowHandle = {
    /** Programmatically focus on root container of Dialog. */
    focus: () => void;
} | null;
export declare const StepFlow: React.ForwardRefExoticComponent<StepFlowProps & React.RefAttributes<StepFlowHandle>>;
export default StepFlow;
