function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useRef } from "react";
import PropTypes from "prop-types";
import { ThemeContext } from "styled-components";
import { flip, offset } from "@floating-ui/dom";
import useClickAwayListener from "../../hooks/__internal__/useClickAwayListener";
import Icon from "../icon";
import Button from "../button";
import StyledSplitButton from "./split-button.style";
import StyledSplitButtonToggle from "./split-button-toggle.style";
import StyledSplitButtonChildrenContainer from "./split-button-children.style";
import guid from "../../__internal__/utils/helpers/guid";
import Popover from "../../__internal__/popover";
import { filterStyledSystemMarginProps, filterOutStyledSystemSpacingProps } from "../../style/utils";
import { baseTheme } from "../../style/themes";
import useChildButtons from "../../hooks/__internal__/useChildButtons";
import SplitButtonContext from "./__internal__/split-button.context";
import useLocale from "../../hooks/__internal__/useLocale";
const CONTENT_WIDTH_RATIO = 0.75;
export const SplitButton = ({
  align = "left",
  buttonType = "secondary",
  children,
  disabled = false,
  iconPosition = "before",
  iconType,
  onClick,
  size = "medium",
  subtext,
  text,
  "data-element": dataElement,
  "data-role": dataRole,
  "aria-label": ariaLabel,
  ...rest
}) => {
  const locale = useLocale();
  const theme = useContext(ThemeContext) || baseTheme;
  const buttonLabelId = useRef(guid());
  const toggleButton = useRef(null);
  const {
    showAdditionalButtons,
    showButtons,
    hideButtons,
    buttonNode,
    handleToggleButtonKeyDown,
    wrapperProps,
    contextValue
  } = useChildButtons(toggleButton, CONTENT_WIDTH_RATIO);
  const mainButtonProps = {
    onMouseEnter: hideButtons,
    onFocus: hideButtons,
    onTouchStart: hideButtons,
    iconPosition,
    buttonType,
    disabled,
    iconType,
    onClick: onClick,
    size,
    subtext,
    ...filterOutStyledSystemSpacingProps(rest)
  };
  const toggleButtonProps = {
    disabled,
    displayed: showAdditionalButtons,
    onTouchStart: showButtons,
    onKeyDown: handleToggleButtonKeyDown,
    onClick: showButtons,
    buttonType,
    size
  };
  function componentTags() {
    return {
      "data-component": "split-button",
      "data-element": dataElement,
      "data-role": dataRole
    };
  }
  function getIconColor() {
    const colorsMap = {
      primary: theme.colors.white,
      secondary: theme.colors.primary
    };
    return colorsMap[buttonType];
  }
  function renderMainButton() {
    return [/*#__PURE__*/React.createElement(Button, _extends({
      "data-element": "main-button",
      key: "main-button",
      id: buttonLabelId.current
    }, mainButtonProps), text), /*#__PURE__*/React.createElement(StyledSplitButtonToggle, _extends({
      "aria-haspopup": "true",
      "aria-expanded": showAdditionalButtons,
      "aria-label": ariaLabel || locale.splitButton.ariaLabel(),
      "data-element": "toggle-button",
      key: "toggle-button",
      type: "button",
      ref: toggleButton
    }, toggleButtonProps), /*#__PURE__*/React.createElement(Icon, {
      type: "dropdown",
      color: getIconColor(),
      bg: "transparent",
      disabled: disabled
    }))];
  }
  function renderAdditionalButtons() {
    if (!showAdditionalButtons) return null;
    return /*#__PURE__*/React.createElement(Popover, {
      placement: "bottom-end",
      reference: buttonNode,
      middleware: [offset(6), flip({
        fallbackStrategy: "initialPlacement"
      })]
    }, /*#__PURE__*/React.createElement(StyledSplitButtonChildrenContainer, _extends({}, wrapperProps, {
      align: align
    }), /*#__PURE__*/React.createElement(SplitButtonContext.Provider, {
      value: contextValue
    }, React.Children.map(children, child => /*#__PURE__*/React.createElement("li", null, child)))));
  }
  const handleClick = useClickAwayListener(hideButtons);
  const marginProps = filterStyledSystemMarginProps(rest);
  return /*#__PURE__*/React.createElement(StyledSplitButton, _extends({
    onClick: handleClick,
    ref: buttonNode
  }, componentTags(), marginProps), renderMainButton(), renderAdditionalButtons());
};
export default SplitButton;