function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useRef } from "react";
import PropTypes from "prop-types";
import guid from "../../../__internal__/utils/helpers/guid";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
import { StyledSimpleColor, StyledColorSampleBox, StyledTickIcon, StyledSimpleColorInput } from "./simple-color.style";
const SimpleColor = /*#__PURE__*/React.forwardRef((props, ref) => {
  const {
    onChange,
    onBlur,
    onMouseDown,
    value,
    name,
    checked = false,
    className,
    id,
    defaultChecked,
    ...rest
  } = props;
  const {
    current: inputId
  } = useRef(id || guid());
  return /*#__PURE__*/React.createElement(StyledSimpleColor, _extends({
    className: className
  }, tagComponent("simple-color", props)), /*#__PURE__*/React.createElement(StyledSimpleColorInput, _extends({
    onChange: onChange,
    onBlur: onBlur,
    onMouseDown: onMouseDown,
    checked: checked,
    name: name,
    type: "radio",
    role: "radio",
    value: value,
    "aria-checked": checked,
    ref: ref,
    id: inputId,
    defaultChecked: defaultChecked
  }, rest)), /*#__PURE__*/React.createElement(StyledColorSampleBox, {
    color: value
  }, checked && /*#__PURE__*/React.createElement(StyledTickIcon, {
    color: value,
    type: "tick"
  })));
});
if (process.env.NODE_ENV !== "production") {
  SimpleColor.propTypes = {
    "checked": PropTypes.bool,
    "className": PropTypes.string,
    "defaultChecked": PropTypes.bool,
    "disabled": PropTypes.bool,
    "id": PropTypes.string,
    "name": PropTypes.string,
    "onBlur": PropTypes.func,
    "onChange": PropTypes.func,
    "onMouseDown": PropTypes.func,
    "value": PropTypes.string.isRequired
  };
}
export { SimpleColor };
SimpleColor.displayName = "SimpleColor";
export default SimpleColor;