import React from "react";
export interface SimpleColorProps {
    /** the value of the color that is represented by this SimpleColor */
    value: string;
    /** the input name */
    name?: string;
    /** the input id */
    id?: string;
    /** if true, input will be disabled */
    disabled?: boolean;
    /** called when the user selects or deselects this color option */
    onChange?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
    /** Prop for `onBlur` events */
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Prop for `onMouseDown` events */
    onMouseDown?: (ev: React.MouseEvent<HTMLInputElement>) => void;
    /** determines if this color option is selected or unselected */
    checked?: boolean;
    /** determines if this color option is selected or unselected when component is used as uncontrolled */
    defaultChecked?: boolean;
    /** [Legacy] Custom classname */
    className?: string;
}
export declare const SimpleColor: React.ForwardRefExoticComponent<SimpleColorProps & React.RefAttributes<HTMLInputElement>>;
export default SimpleColor;
