function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useState, useRef, useMemo, useEffect, useImperativeHandle } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import Events from "../../__internal__/utils/helpers/events";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import Fieldset from "../../__internal__/fieldset";
import SimpleColor from "./simple-color";
import RadioButtonMapper from "../../__internal__/radio-button-mapper/radio-button-mapper.component";
import { StyledContent, StyledColorOptions } from "./simple-color-picker.style";
import ValidationIcon from "../../__internal__/validations/validation-icon.component";
import { InputGroupContext } from "../../__internal__/input-behaviour";
import { filterStyledSystemMarginProps } from "../../style/utils";
import Logger from "../../__internal__/utils/logger";
let deprecateUncontrolledWarnTriggered = false;
const SimpleColorPicker = /*#__PURE__*/React.forwardRef((props, ref) => {
  const {
    children,
    error,
    warning,
    info,
    name,
    legend,
    onChange,
    onBlur,
    onKeyDown,
    value,
    isBlurBlocked = false,
    maxWidth = 300,
    childWidth = 58,
    validationOnLegend,
    required,
    ...rest
  } = props;
  const hasProperChildren = useMemo(() => {
    let hasSimpleColorChildren = true;
    React.Children.toArray(children).forEach(child => {
      if (typeof child === "string" || /*#__PURE__*/React.isValidElement(child) && child.type.displayName !== "SimpleColor") {
        hasSimpleColorChildren = false;
      }
    });
    return hasSimpleColorChildren;
  }, [children]);
  !hasProperChildren ? process.env.NODE_ENV !== "production" ? invariant(false, `SimpleColorPicker accepts only children of type \`${SimpleColor.displayName}\`.`) : invariant(false) : void 0;
  const filteredChildren = useMemo(() => React.Children.toArray(children).filter(child => /*#__PURE__*/React.isValidElement(child)), [children]);
  const internalRef = useRef(null);
  const [blurBlocked, setIsBlurBlocked] = useState(isBlurBlocked);
  const [focusedElement, setFocusedElement] = useState(null);
  const itemsPerRow = Math.floor(+maxWidth / +childWidth);
  const rowCount = Math.ceil(filteredChildren?.length / itemsPerRow);
  let blankSlots = itemsPerRow * rowCount - filteredChildren?.length;
  let currentRow = 1;
  let loopCounter = 1;
  const gridItemRefs = useRef([]);
  const navigationGrid = filteredChildren.map((child, index) => {
    const allowUp = currentRow !== 1;
    let allowDown = false;
    if (currentRow + 1 === rowCount && blankSlots - itemsPerRow < 0) {
      allowDown = true;
      blankSlots += 1;
    } else if (currentRow + 1 !== rowCount && currentRow !== rowCount && rowCount > 1) {
      allowDown = true;
    }
    if (loopCounter === itemsPerRow) {
      loopCounter = 0;
      currentRow += 1;
    }
    let upItem;
    if (allowUp) {
      upItem = index - itemsPerRow;
    }
    let downItem;
    if (allowDown) {
      downItem = itemsPerRow + index;
    }
    const childProps = {
      ref: element => {
        gridItemRefs.current[index] = element;
      },
      "data-up": allowUp,
      "data-down": allowDown,
      "data-item-up": upItem,
      "data-item-down": downItem,
      required
    };
    loopCounter += 1;
    return /*#__PURE__*/React.cloneElement(child, childProps);
  });
  useImperativeHandle(ref, () => ({
    gridItemRefs: gridItemRefs.current
  }), [gridItemRefs]);
  const getElementPosition = useCallback(target => {
    return navigationGrid.findIndex(element => {
      return target.getAttribute("value") === element.props.value;
    });
  }, [navigationGrid]);
  const onKeyDownHandler = useCallback(e => {
    if (onKeyDown) {
      onKeyDown(e);
    }
    const arrowKeys = [Events.isLeftKey(e), Events.isUpKey(e), Events.isRightKey(e), Events.isDownKey(e)];
    if (!arrowKeys.includes(true)) return;
    e.preventDefault();
    let itemIndex = null;
    const target = e.target;
    if (Events.isUpKey(e)) {
      if (target.getAttribute("data-up") !== "true") return;
      itemIndex = +target.getAttribute("data-item-up");
    } else if (Events.isDownKey(e)) {
      if (target.getAttribute("data-down") !== "true") return;
      itemIndex = +target.getAttribute("data-item-down");
    }
    if (Events.isLeftKey(e) || Events.isRightKey(e)) {
      if (Events.isLeftKey(e)) {
        itemIndex = getElementPosition(target) - 1;
      } else {
        itemIndex = getElementPosition(target) + 1;
      }
      if (itemIndex < 0) {
        itemIndex = navigationGrid.length - 1;
      } else if (itemIndex > navigationGrid.length - 1) {
        itemIndex = 0;
      }
    }

    /* istanbul ignore else */
    if (itemIndex !== null) {
      const item = gridItemRefs.current[itemIndex];
      item?.focus();
      item?.click();
    }
  }, [onKeyDown, navigationGrid, getElementPosition]);
  const handleClickOutside = ev => {
    if (internalRef.current && ev.target && !internalRef.current.contains(ev.target)) {
      setIsBlurBlocked(false);
    }
  };
  useEffect(() => {
    document.addEventListener("mousedown", handleClickOutside);
    document.addEventListener("keydown", handleClickOutside);
    return () => {
      document.removeEventListener("mousedown", handleClickOutside);
      document.removeEventListener("keydown", handleClickOutside);
    };
  });
  const handleOnBlur = ev => {
    ev.preventDefault();
    if (!blurBlocked && onBlur) {
      onBlur(ev);
    }
  };
  const handleOnMouseDown = ev => {
    setIsBlurBlocked(true);

    // If the mousedown event occurred on the currently-focused <SimpleColor>
    if (focusedElement !== null && focusedElement === ev.target) {
      ev.preventDefault();

      // If a different <SimpleColor> is currently focused
    } else if (focusedElement !== null) {
      ev.preventDefault();
      setIsBlurBlocked(false);
      setFocusedElement(ev.target);

      // If no <SimpleColor> is currently focused
    } else {
      setIsBlurBlocked(true);
      setFocusedElement(ev.target);
    }
  };
  const validationProps = {
    error,
    warning,
    info
  };
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Simple Color Picker` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  return /*#__PURE__*/React.createElement(Fieldset, _extends({
    role: "radiogroup",
    legend: legend,
    isRequired: required
  }, validationOnLegend && validationProps, tagComponent("simple-color-picker", props), filterStyledSystemMarginProps(rest)), /*#__PURE__*/React.createElement(StyledContent, null, /*#__PURE__*/React.createElement(InputGroupContext.Consumer, null, ({
    onMouseEnter,
    onMouseLeave
  }) => /*#__PURE__*/React.createElement(StyledColorOptions, _extends({
    maxWidth: maxWidth,
    childWidth: childWidth,
    ref: internalRef,
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave
  }, validationProps), /*#__PURE__*/React.createElement(RadioButtonMapper, {
    name: name,
    value: value,
    onChange: onChange,
    onMouseDown: handleOnMouseDown,
    onKeyDown: onKeyDownHandler,
    onBlur: handleOnBlur
  }, navigationGrid))), !validationOnLegend && /*#__PURE__*/React.createElement(ValidationIcon, _extends({}, validationProps, {
    tooltipFlipOverrides: ["top", "bottom"]
  }))));
});
if (process.env.NODE_ENV !== "production") {
  SimpleColorPicker.propTypes = {
    "children": PropTypes.node,
    "childWidth": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "isBlurBlocked": PropTypes.bool,
    "legend": PropTypes.string.isRequired,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "maxWidth": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string.isRequired,
    "onBlur": PropTypes.func,
    "onChange": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "required": PropTypes.bool,
    "validationOnLegend": PropTypes.bool,
    "value": PropTypes.string,
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool])
  };
}
export { SimpleColorPicker };
SimpleColorPicker.displayName = "SimpleColorPicker";
export default SimpleColorPicker;