function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useRef } from "react";
import PropTypes from "prop-types";
import Modal from "../modal";
import StyledSidebar from "./sidebar.style";
import IconButton from "../icon-button";
import Icon from "../icon";
import FocusTrap from "../../__internal__/focus-trap";
import SidebarHeader from "./__internal__/sidebar-header";
import Box from "../box";
import createGuid from "../../__internal__/utils/helpers/guid";
import useLocale from "../../hooks/__internal__/useLocale";
import { filterStyledSystemPaddingProps } from "../../style/utils";
import useIsStickyFooterForm from "../../hooks/__internal__/useIsStickyFooterForm";
import useModalAria from "../../hooks/__internal__/useModalAria/useModalAria";

// TODO FE-5408 will investigate why React.RefObject<T> produces a failed prop type when current = null

export const SidebarContext = /*#__PURE__*/React.createContext({});
const Sidebar = /*#__PURE__*/React.forwardRef(({
  "aria-describedby": ariaDescribedBy,
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  open,
  bespokeFocusTrap,
  disableAutoFocus = false,
  disableEscKey = false,
  enableBackgroundUI = false,
  header,
  position = "right",
  size = "medium",
  children,
  onCancel,
  role = "dialog",
  focusFirstElement,
  focusableContainers,
  focusableSelectors,
  width,
  headerPadding = {},
  topModalOverride,
  ...rest
}, ref) => {
  const locale = useLocale();
  const {
    current: headerId
  } = useRef(createGuid());
  const hasStickyFooter = useIsStickyFooterForm(children);
  const sidebarRef = useRef(null);
  const setRefs = useCallback(reference => {
    sidebarRef.current = reference;
    if (!ref) return;
    if (typeof ref === "object") ref.current = reference;
    if (typeof ref === "function") ref(reference);
  }, [ref]);
  const isTopModal = useModalAria(sidebarRef);
  const closeIcon = () => {
    if (!onCancel) return null;
    return /*#__PURE__*/React.createElement(IconButton, {
      "aria-label": locale.sidebar.ariaLabels.close(),
      onClick: onCancel,
      "data-element": "close"
    }, /*#__PURE__*/React.createElement(Icon, {
      type: "close"
    }));
  };
  const componentTags = {
    "data-component": "sidebar",
    "data-element": rest["data-element"],
    "data-role": rest["data-role"]
  };
  const sidebar = /*#__PURE__*/React.createElement(StyledSidebar, _extends({
    "aria-modal": !enableBackgroundUI && isTopModal,
    "aria-describedby": ariaDescribedBy,
    "aria-label": ariaLabel,
    "aria-labelledby": !ariaLabelledBy && !ariaLabel ? headerId : ariaLabelledBy,
    ref: setRefs,
    position: position,
    size: size,
    "data-element": "sidebar",
    onCancel: onCancel,
    role: role
  }, filterStyledSystemPaddingProps(rest), {
    width: width
  }), header && /*#__PURE__*/React.createElement(SidebarHeader, _extends({
    closeIcon: closeIcon()
  }, headerPadding, {
    id: headerId
  }), header), !header && closeIcon(), /*#__PURE__*/React.createElement(Box, _extends({
    "data-element": "sidebar-content",
    pt: "var(--spacing300)",
    pb: "var(--spacing400)",
    px: "var(--spacing400)"
  }, filterStyledSystemPaddingProps(rest), {
    scrollVariant: "light",
    overflow: hasStickyFooter ? undefined : "auto",
    flex: "1"
  }), /*#__PURE__*/React.createElement(SidebarContext.Provider, {
    value: {
      isInSidebar: true
    }
  }, children)));
  return /*#__PURE__*/React.createElement(Modal, _extends({
    open: open,
    onCancel: onCancel,
    disableEscKey: disableEscKey,
    enableBackgroundUI: enableBackgroundUI,
    topModalOverride: topModalOverride
  }, componentTags), enableBackgroundUI ? sidebar : /*#__PURE__*/React.createElement(FocusTrap, {
    wrapperRef: sidebarRef,
    isOpen: open,
    additionalWrapperRefs: focusableContainers,
    focusableSelectors: focusableSelectors,
    focusFirstElement: focusFirstElement,
    autoFocus: !disableAutoFocus,
    bespokeTrap: bespokeFocusTrap
  }, sidebar));
});
if (process.env.NODE_ENV !== "production") {
  Sidebar.propTypes = {
    "aria-describedby": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "bespokeFocusTrap": PropTypes.func,
    "children": PropTypes.node,
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "disableAutoFocus": PropTypes.bool,
    "disableEscKey": PropTypes.bool,
    "enableBackgroundUI": PropTypes.bool,
    "focusableContainers": PropTypes.arrayOf(PropTypes.shape({
      "current": function (props, propName) {
        if (props[propName] == null) {
          return null;
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }
    })),
    "focusableSelectors": PropTypes.string,
    "focusFirstElement": PropTypes.shape({
      "current": PropTypes.oneOfType([PropTypes.oneOf([null]), function (props, propName) {
        if (props[propName] == null) {
          return new Error("Prop '" + propName + "' is required but wasn't specified");
        } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
          return new Error("Expected prop '" + propName + "' to be of type Element");
        }
      }]).isRequired
    }),
    "header": PropTypes.node,
    "headerPadding": PropTypes.shape({
      "p": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "padding": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "paddingY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "pb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "pl": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "pr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "pt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "px": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string]),
      "py": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
        "__@toStringTag": PropTypes.string.isRequired,
        "description": PropTypes.string,
        "toString": PropTypes.func.isRequired,
        "valueOf": PropTypes.func.isRequired
      }), PropTypes.string])
    }),
    "onCancel": PropTypes.func,
    "open": PropTypes.bool.isRequired,
    "p": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "padding": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "paddingY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pl": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "position": PropTypes.oneOf(["left", "right"]),
    "pr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "pt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "px": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "py": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "role": PropTypes.string,
    "size": PropTypes.oneOf(["extra-large", "extra-small", "large", "medium-large", "medium-small", "medium", "small"]),
    "topModalOverride": PropTypes.bool,
    "width": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])
  };
}
export { Sidebar };
Sidebar.displayName = "Sidebar";
export default Sidebar;