function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import Heading from "../heading";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { filterStyledSystemMarginProps } from "../../style/utils";
import { StyledSettingsRow, StyledSettingsRowHeader, StyledSettingsRowInput } from "./settings-row.style";
export const SettingsRow = ({
  title,
  headingType = "h3",
  children,
  description,
  divider = true,
  className,
  ...rest
}) => {
  const heading = () => {
    if (!title) return null;
    return /*#__PURE__*/React.createElement(Heading, {
      headingType: headingType,
      title: title,
      subheader: description,
      separator: description !== undefined,
      divider: false
    });
  };
  return /*#__PURE__*/React.createElement(StyledSettingsRow, _extends({
    className: className,
    hasDivider: divider
  }, tagComponent("settings-row", rest), {
    m: 0
  }, filterStyledSystemMarginProps(rest)), /*#__PURE__*/React.createElement(StyledSettingsRowHeader, null, heading()), /*#__PURE__*/React.createElement(StyledSettingsRowInput, null, children));
};
SettingsRow.displayName = "SettingsRow";
export default SettingsRow;