import React from "react";
import { MarginProps } from "styled-system";
import { HeadingType } from "../heading";
export interface SettingsRowProps extends MarginProps {
    /**  A title for this group of settings. */
    title?: string;
    /** Defines the HTML heading element of the `title` within the component. */
    headingType?: HeadingType;
    /** Content to be rendered inside the component. */
    children?: React.ReactNode;
    /**  A string or JSX object that provides a short description about the group of settings. */
    description?: React.ReactNode;
    /** Shows a divider below the component. */
    divider?: boolean;
    /**  The CSS classes to apply to the component. */
    className?: string;
}
export declare const SettingsRow: {
    ({ title, headingType, children, description, divider, className, ...rest }: SettingsRowProps): React.JSX.Element;
    displayName: string;
};
export default SettingsRow;
