function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback } from "react";
import useLocale from "../../../hooks/__internal__/useLocale";
import StyledOptionRow from "../option-row/option-row.style";
import StyledOption from "../option/option.style";
import Option from "../option";
import OptionRow from "../option-row/option-row.component";
import highlightPartOfText from "./highlight-part-of-text";
const filterOptions = (option, filterText) => {
  const processedText = option.props.text?.toLowerCase();
  const processedValue = filterText.toLowerCase();
  if (processedText.includes(processedValue)) {
    return option;
  }
  return null;
};
const filterOptionRows = (optionRow, filterText) => {
  const cells = React.Children.toArray(optionRow.props.children);
  const hasText = cells.find(cell => {
    /* istanbul ignore if */
    if (! /*#__PURE__*/React.isValidElement(cell)) {
      return false;
    }
    if (typeof cell.props.children === "string") {
      const processedText = cell.props.children.toLowerCase();
      const processedValue = filterText.toLowerCase();
      return processedText.includes(processedValue);
    }
    // filter recursively based on children
    return filterOptionRows(cell, filterText);
  });
  if (hasText) {
    return optionRow;
  }
  return null;
};
const filterChildren = filterText => children => {
  const filteredChildren = React.Children.map(children, child => {
    /* istanbul ignore if */
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return null;
    }
    if (child.type === Option) {
      return filterOptions(child, filterText);
    }
    /* istanbul ignore else */
    if (child.type === OptionRow) {
      return filterOptionRows(child, filterText);
    }
    /* istanbul ignore next */
    return null;
  });
  if (React.Children.count(filteredChildren)) return filteredChildren;
  return null;
};
function addHighlightedContent(filteredElements, filterText) {
  return React.Children.map(filteredElements, child => {
    let highlightedContent;
    /* istanbul ignore if */
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return child;
    }
    if (child.type === Option) {
      highlightedContent = highlightPartOfText(child.props.text, filterText);
    }
    if (child.type === OptionRow) {
      highlightedContent = React.Children.map(child.props.children, cell => {
        /* istanbul ignore if */
        if (! /*#__PURE__*/React.isValidElement(cell)) {
          return cell;
        }
        return /*#__PURE__*/React.cloneElement(cell, {
          children: highlightPartOfText(cell.props.children, filterText)
        });
      });
    }
    return /*#__PURE__*/React.cloneElement(child, {
      children: highlightedContent
    });
  });
}
/** Filters wrapped component children based on provided filter text and highlights matching content */
const withFilter = WrappedComponent => {
  const FilteredComponent = /*#__PURE__*/React.forwardRef(({
    children,
    filterText,
    noResultsMessage,
    isLoading,
    multiColumn,
    tableHeader,
    ...props
  }, forwardedRef) => {
    const l = useLocale();
    const getFilteredChildren = useCallback(() => {
      let filteredElements = children;
      if (filterText && !isLoading) {
        filteredElements = filterChildren(filterText)(children);
        if (!filteredElements) {
          const noResultsText = l.select.noResultsForTerm(filterText);
          if (multiColumn) {
            const colSpan = /*#__PURE__*/React.isValidElement(tableHeader) ? /* istanbul ignore next */React.Children.count(tableHeader?.props?.children) : 1;
            return /*#__PURE__*/React.createElement(StyledOptionRow, null, /*#__PURE__*/React.createElement("td", {
              style: {
                fontWeight: "normal"
              },
              colSpan: colSpan
            }, noResultsMessage || noResultsText));
          }
          return /*#__PURE__*/React.createElement(StyledOption, null, noResultsMessage || noResultsText);
        }
        return addHighlightedContent(filteredElements, filterText);
      }
      return children;
    }, [children, filterText, isLoading, multiColumn, noResultsMessage, tableHeader, l]);
    const wrappedComponentProps = {
      filterText,
      isLoading,
      multiColumn,
      tableHeader,
      ...props
    };
    return /*#__PURE__*/React.createElement(WrappedComponent, _extends({}, wrappedComponentProps, {
      ref: forwardedRef
    }), getFilteredChildren());
  });
  FilteredComponent.displayName = "FilteredComponent";
  return FilteredComponent;
};
export default withFilter;