import React from "react";
import MatchingText from "./matching-text.style";
function highlightPartOfText(text, partToHighlight) {
  if (!partToHighlight || !partToHighlight.length || !text) return text;
  const lowercaseText = text.toLowerCase();
  const lowercasePart = partToHighlight.toLowerCase();
  const indexOfFirstMatch = lowercaseText.indexOf(lowercasePart);
  if (indexOfFirstMatch === -1) {
    return text;
  }
  const precedingText = text.substr(0, indexOfFirstMatch);
  const matchingText = text.substr(indexOfFirstMatch, partToHighlight.length);
  const followingText = text.substr(indexOfFirstMatch + partToHighlight.length, text.length);
  let followingTextNode = followingText;
  if (followingText.length >= partToHighlight.length) {
    followingTextNode = highlightPartOfText(followingText, partToHighlight);
  }
  const newValue = [/*#__PURE__*/React.createElement("span", {
    key: "preceding"
  }, precedingText), /*#__PURE__*/React.createElement(MatchingText, {
    key: "match"
  }, matchingText), /*#__PURE__*/React.createElement("span", {
    key: "following"
  }, followingTextNode)];
  return newValue;
}
export default function highlightPartOfTextRecursive(child, partToHighlight) {
  if (typeof child === "string") {
    return highlightPartOfText(child, partToHighlight);
  }
  /* istanbul ignore if */
  if (! /*#__PURE__*/React.isValidElement(child)) {
    return child;
  }
  const highlightedChildren = React.Children.map(child.props.children, grandChild => highlightPartOfTextRecursive(grandChild, partToHighlight));
  return /*#__PURE__*/React.cloneElement(child, {
    children: highlightedChildren
  });
}