function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useMemo } from "react";
import PropTypes from "prop-types";
import { offset, size as sizeMiddleware } from "@floating-ui/dom";
import useFloating from "../../../hooks/__internal__/useFloating";
import Textbox from "../../textbox";
import SelectText from "../__internal__/select-text";
import useLocale from "../../../hooks/__internal__/useLocale";
import { SelectTextboxContext } from "./select-textbox-context";
const floatingMiddleware = [offset(({
  rects
}) => ({
  mainAxis: -rects.reference.height
})), sizeMiddleware({
  apply({
    rects,
    elements
  }) {
    elements.reference.style.height = `${rects.floating.height}px`;
    elements.floating.style.width = `${rects.reference.width}px`;
  }
})];
const SelectTextbox = /*#__PURE__*/React.forwardRef(({
  ariaLabel,
  ariaLabelledby,
  accessibilityLabelId,
  labelId,
  "aria-controls": ariaControls,
  disabled,
  isOpen,
  id,
  readOnly,
  placeholder,
  size = "medium",
  onClick,
  onFocus,
  onBlur,
  onChange,
  selectedValue,
  required,
  isOptional,
  textboxRef,
  hasTextCursor,
  transparent,
  activeDescendantId,
  onKeyDown,
  ...restProps
}, ref) => {
  const reference = useMemo(() => ({
    current: textboxRef?.parentElement?.parentElement || null
  }), [textboxRef]);
  const floating = useMemo(() => ({
    current: textboxRef?.parentElement || null
  }), [textboxRef]);
  useFloating({
    isOpen,
    reference,
    floating,
    strategy: "fixed",
    animationFrame: true,
    middleware: floatingMiddleware
  });
  const l = useLocale();
  function handleTextboxClick(event) {
    onClick?.(event);
  }
  function handleTextboxFocus(event) {
    if (disabled || readOnly) {
      return;
    }
    if (onFocus) {
      onFocus(event);
    }
  }
  function handleTextboxBlur(event) {
    if (onBlur) {
      onBlur(event);
    }
  }
  const textboxProps = {
    disabled,
    id,
    readOnly,
    required,
    isOptional,
    onClick: handleTextboxClick,
    onFocus: handleTextboxFocus,
    onBlur: handleTextboxBlur,
    labelId,
    type: "text",
    ref,
    onKeyDown,
    ...restProps
  };
  const inputAriaAttributes = {
    "aria-expanded": readOnly ? undefined : isOpen,
    "aria-labelledby": accessibilityLabelId ? `${ariaLabelledby || labelId} ${accessibilityLabelId}` : ariaLabelledby,
    "aria-activedescendant": activeDescendantId,
    "aria-controls": ariaControls,
    "aria-autocomplete": hasTextCursor ? "both" : undefined,
    role: readOnly ? undefined : "combobox"
  };
  const hasStringValue = typeof selectedValue === "string" || Array.isArray(selectedValue) && typeof selectedValue[0] === "string";
  return /*#__PURE__*/React.createElement(SelectTextboxContext.Provider, {
    value: {
      isInputInSelect: true
    }
  }, /*#__PURE__*/React.createElement(Textbox, _extends({
    "aria-label": ariaLabel,
    "data-element": "select-input",
    inputIcon: "dropdown",
    autoComplete: "off",
    size: size,
    onChange: onChange,
    value: hasStringValue ? selectedValue : undefined,
    placeholder: hasTextCursor ? placeholder || l.select.placeholder() : undefined
  }, inputAriaAttributes, textboxProps, {
    my: 0 // prevents any form spacing being applied
  }), !hasTextCursor && /*#__PURE__*/React.createElement(SelectText, _extends({
    transparent: transparent,
    placeholder: placeholder || l.select.placeholder(),
    onClick: disabled || readOnly ? undefined : handleTextboxClick,
    disabled: disabled,
    readOnly: readOnly,
    size: size
  }, restProps))));
});
if (process.env.NODE_ENV !== "production") {
  SelectTextbox.propTypes = {
    "about": PropTypes.string,
    "accept": PropTypes.string,
    "accessibilityLabelId": PropTypes.string,
    "accessKey": PropTypes.string,
    "activeDescendantId": PropTypes.string,
    "adaptiveLabelBreakpoint": PropTypes.number,
    "align": PropTypes.oneOf(["left", "right"]),
    "alt": PropTypes.string,
    "aria-activedescendant": PropTypes.string,
    "aria-atomic": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-autocomplete": PropTypes.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-checked": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-colcount": PropTypes.number,
    "aria-colindex": PropTypes.number,
    "aria-colspan": PropTypes.number,
    "aria-controls": PropTypes.string,
    "aria-current": PropTypes.oneOfType([PropTypes.oneOf(["date", "false", "location", "page", "step", "time", "true"]), PropTypes.bool]),
    "aria-describedby": PropTypes.string,
    "aria-details": PropTypes.string,
    "aria-disabled": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-dropeffect": PropTypes.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": PropTypes.string,
    "aria-expanded": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-flowto": PropTypes.string,
    "aria-grabbed": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-haspopup": PropTypes.oneOfType([PropTypes.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), PropTypes.bool]),
    "aria-hidden": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-invalid": PropTypes.oneOfType([PropTypes.oneOf(["false", "grammar", "spelling", "true"]), PropTypes.bool]),
    "aria-keyshortcuts": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "aria-level": PropTypes.number,
    "aria-live": PropTypes.oneOf(["assertive", "off", "polite"]),
    "aria-modal": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiline": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiselectable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-orientation": PropTypes.oneOf(["horizontal", "vertical"]),
    "aria-owns": PropTypes.string,
    "aria-placeholder": PropTypes.string,
    "aria-posinset": PropTypes.number,
    "aria-pressed": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-readonly": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-relevant": PropTypes.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-roledescription": PropTypes.string,
    "aria-rowcount": PropTypes.number,
    "aria-rowindex": PropTypes.number,
    "aria-rowspan": PropTypes.number,
    "aria-selected": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-setsize": PropTypes.number,
    "aria-sort": PropTypes.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": PropTypes.number,
    "aria-valuemin": PropTypes.number,
    "aria-valuenow": PropTypes.number,
    "aria-valuetext": PropTypes.string,
    "ariaDescribedBy": PropTypes.string,
    "ariaLabel": PropTypes.string,
    "ariaLabelledby": PropTypes.string,
    "as": PropTypes.elementType,
    "autoCapitalize": PropTypes.string,
    "autoComplete": PropTypes.string,
    "autoCorrect": PropTypes.string,
    "autoFocus": PropTypes.bool,
    "autoSave": PropTypes.string,
    "capture": PropTypes.oneOfType([PropTypes.oneOf(["environment", "user"]), PropTypes.bool]),
    "checked": PropTypes.bool,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "color": PropTypes.string,
    "content": PropTypes.string,
    "contentEditable": PropTypes.oneOfType([PropTypes.oneOf(["false", "inherit", "true"]), PropTypes.bool]),
    "contextMenu": PropTypes.string,
    "dangerouslySetInnerHTML": PropTypes.shape({
      "__html": PropTypes.oneOfType([PropTypes.object, PropTypes.string]).isRequired
    }),
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "datatype": PropTypes.string,
    "defaultChecked": PropTypes.bool,
    "defaultValue": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string), PropTypes.number, PropTypes.string]),
    "deferTimeout": PropTypes.number,
    "dir": PropTypes.string,
    "disabled": PropTypes.bool,
    "draggable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "enterKeyHint": PropTypes.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "fieldHelp": PropTypes.node,
    "form": PropTypes.string,
    "formAction": PropTypes.string,
    "formattedValue": PropTypes.string,
    "formEncType": PropTypes.string,
    "formMethod": PropTypes.string,
    "formNoValidate": PropTypes.bool,
    "formTarget": PropTypes.string,
    "hasTextCursor": PropTypes.bool,
    "height": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "helpAriaLabel": PropTypes.string,
    "hidden": PropTypes.bool,
    "iconOnClick": PropTypes.func,
    "iconOnMouseDown": PropTypes.func,
    "iconTabIndex": PropTypes.number,
    "id": PropTypes.string,
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "inlist": PropTypes.any,
    "inputHint": PropTypes.string,
    "inputIcon": PropTypes.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "marker", "message", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]),
    "inputMode": PropTypes.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputWidth": PropTypes.number,
    "is": PropTypes.string,
    "isOpen": PropTypes.bool,
    "isOptional": PropTypes.bool,
    "itemID": PropTypes.string,
    "itemProp": PropTypes.string,
    "itemRef": PropTypes.string,
    "itemScope": PropTypes.bool,
    "itemType": PropTypes.string,
    "label": PropTypes.string,
    "labelAlign": PropTypes.oneOf(["left", "right"]),
    "labelHelp": PropTypes.node,
    "labelId": PropTypes.string,
    "labelInline": PropTypes.bool,
    "labelSpacing": PropTypes.oneOf([1, 2]),
    "labelWidth": PropTypes.number,
    "lang": PropTypes.string,
    "leftChildren": PropTypes.node,
    "list": PropTypes.string,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "max": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "maxLength": PropTypes.number,
    "maxWidth": PropTypes.string,
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "min": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "minLength": PropTypes.number,
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "multiple": PropTypes.bool,
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string,
    "nonce": PropTypes.string,
    "onAbort": PropTypes.func,
    "onAbortCapture": PropTypes.func,
    "onAnimationEnd": PropTypes.func,
    "onAnimationEndCapture": PropTypes.func,
    "onAnimationIteration": PropTypes.func,
    "onAnimationIterationCapture": PropTypes.func,
    "onAnimationStart": PropTypes.func,
    "onAnimationStartCapture": PropTypes.func,
    "onAuxClick": PropTypes.func,
    "onAuxClickCapture": PropTypes.func,
    "onBeforeInput": PropTypes.func,
    "onBeforeInputCapture": PropTypes.func,
    "onBlur": PropTypes.func,
    "onBlurCapture": PropTypes.func,
    "onCanPlay": PropTypes.func,
    "onCanPlayCapture": PropTypes.func,
    "onCanPlayThrough": PropTypes.func,
    "onCanPlayThroughCapture": PropTypes.func,
    "onChange": PropTypes.func,
    "onChangeCapture": PropTypes.func,
    "onChangeDeferred": PropTypes.func,
    "onClick": PropTypes.func,
    "onClickCapture": PropTypes.func,
    "onCompositionEnd": PropTypes.func,
    "onCompositionEndCapture": PropTypes.func,
    "onCompositionStart": PropTypes.func,
    "onCompositionStartCapture": PropTypes.func,
    "onCompositionUpdate": PropTypes.func,
    "onCompositionUpdateCapture": PropTypes.func,
    "onContextMenu": PropTypes.func,
    "onContextMenuCapture": PropTypes.func,
    "onCopy": PropTypes.func,
    "onCopyCapture": PropTypes.func,
    "onCut": PropTypes.func,
    "onCutCapture": PropTypes.func,
    "onDoubleClick": PropTypes.func,
    "onDoubleClickCapture": PropTypes.func,
    "onDrag": PropTypes.func,
    "onDragCapture": PropTypes.func,
    "onDragEnd": PropTypes.func,
    "onDragEndCapture": PropTypes.func,
    "onDragEnter": PropTypes.func,
    "onDragEnterCapture": PropTypes.func,
    "onDragExit": PropTypes.func,
    "onDragExitCapture": PropTypes.func,
    "onDragLeave": PropTypes.func,
    "onDragLeaveCapture": PropTypes.func,
    "onDragOver": PropTypes.func,
    "onDragOverCapture": PropTypes.func,
    "onDragStart": PropTypes.func,
    "onDragStartCapture": PropTypes.func,
    "onDrop": PropTypes.func,
    "onDropCapture": PropTypes.func,
    "onDurationChange": PropTypes.func,
    "onDurationChangeCapture": PropTypes.func,
    "onEmptied": PropTypes.func,
    "onEmptiedCapture": PropTypes.func,
    "onEncrypted": PropTypes.func,
    "onEncryptedCapture": PropTypes.func,
    "onEnded": PropTypes.func,
    "onEndedCapture": PropTypes.func,
    "onError": PropTypes.func,
    "onErrorCapture": PropTypes.func,
    "onFocus": PropTypes.func,
    "onFocusCapture": PropTypes.func,
    "onGotPointerCapture": PropTypes.func,
    "onGotPointerCaptureCapture": PropTypes.func,
    "onInput": PropTypes.func,
    "onInputCapture": PropTypes.func,
    "onInvalid": PropTypes.func,
    "onInvalidCapture": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onKeyDownCapture": PropTypes.func,
    "onKeyPress": PropTypes.func,
    "onKeyPressCapture": PropTypes.func,
    "onKeyUp": PropTypes.func,
    "onKeyUpCapture": PropTypes.func,
    "onLoad": PropTypes.func,
    "onLoadCapture": PropTypes.func,
    "onLoadedData": PropTypes.func,
    "onLoadedDataCapture": PropTypes.func,
    "onLoadedMetadata": PropTypes.func,
    "onLoadedMetadataCapture": PropTypes.func,
    "onLoadStart": PropTypes.func,
    "onLoadStartCapture": PropTypes.func,
    "onLostPointerCapture": PropTypes.func,
    "onLostPointerCaptureCapture": PropTypes.func,
    "onMouseDown": PropTypes.func,
    "onMouseDownCapture": PropTypes.func,
    "onMouseEnter": PropTypes.func,
    "onMouseLeave": PropTypes.func,
    "onMouseMove": PropTypes.func,
    "onMouseMoveCapture": PropTypes.func,
    "onMouseOut": PropTypes.func,
    "onMouseOutCapture": PropTypes.func,
    "onMouseOver": PropTypes.func,
    "onMouseOverCapture": PropTypes.func,
    "onMouseUp": PropTypes.func,
    "onMouseUpCapture": PropTypes.func,
    "onPaste": PropTypes.func,
    "onPasteCapture": PropTypes.func,
    "onPause": PropTypes.func,
    "onPauseCapture": PropTypes.func,
    "onPlay": PropTypes.func,
    "onPlayCapture": PropTypes.func,
    "onPlaying": PropTypes.func,
    "onPlayingCapture": PropTypes.func,
    "onPointerCancel": PropTypes.func,
    "onPointerCancelCapture": PropTypes.func,
    "onPointerDown": PropTypes.func,
    "onPointerDownCapture": PropTypes.func,
    "onPointerEnter": PropTypes.func,
    "onPointerEnterCapture": PropTypes.func,
    "onPointerLeave": PropTypes.func,
    "onPointerLeaveCapture": PropTypes.func,
    "onPointerMove": PropTypes.func,
    "onPointerMoveCapture": PropTypes.func,
    "onPointerOut": PropTypes.func,
    "onPointerOutCapture": PropTypes.func,
    "onPointerOver": PropTypes.func,
    "onPointerOverCapture": PropTypes.func,
    "onPointerUp": PropTypes.func,
    "onPointerUpCapture": PropTypes.func,
    "onProgress": PropTypes.func,
    "onProgressCapture": PropTypes.func,
    "onRateChange": PropTypes.func,
    "onRateChangeCapture": PropTypes.func,
    "onReset": PropTypes.func,
    "onResetCapture": PropTypes.func,
    "onScroll": PropTypes.func,
    "onScrollCapture": PropTypes.func,
    "onSeeked": PropTypes.func,
    "onSeekedCapture": PropTypes.func,
    "onSeeking": PropTypes.func,
    "onSeekingCapture": PropTypes.func,
    "onSelect": PropTypes.func,
    "onSelectCapture": PropTypes.func,
    "onStalled": PropTypes.func,
    "onStalledCapture": PropTypes.func,
    "onSubmit": PropTypes.func,
    "onSubmitCapture": PropTypes.func,
    "onSuspend": PropTypes.func,
    "onSuspendCapture": PropTypes.func,
    "onTimeUpdate": PropTypes.func,
    "onTimeUpdateCapture": PropTypes.func,
    "onTouchCancel": PropTypes.func,
    "onTouchCancelCapture": PropTypes.func,
    "onTouchEnd": PropTypes.func,
    "onTouchEndCapture": PropTypes.func,
    "onTouchMove": PropTypes.func,
    "onTouchMoveCapture": PropTypes.func,
    "onTouchStart": PropTypes.func,
    "onTouchStartCapture": PropTypes.func,
    "onTransitionEnd": PropTypes.func,
    "onTransitionEndCapture": PropTypes.func,
    "onVolumeChange": PropTypes.func,
    "onVolumeChangeCapture": PropTypes.func,
    "onWaiting": PropTypes.func,
    "onWaitingCapture": PropTypes.func,
    "onWheel": PropTypes.func,
    "onWheelCapture": PropTypes.func,
    "pattern": PropTypes.string,
    "placeholder": PropTypes.string,
    "prefix": PropTypes.string,
    "property": PropTypes.string,
    "radioGroup": PropTypes.string,
    "readOnly": PropTypes.bool,
    "rel": PropTypes.string,
    "required": PropTypes.bool,
    "resource": PropTypes.string,
    "results": PropTypes.number,
    "rev": PropTypes.string,
    "reverse": PropTypes.bool,
    "role": PropTypes.oneOfType([PropTypes.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "security": PropTypes.string,
    "selectedValue": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string), PropTypes.object, PropTypes.string]),
    "size": PropTypes.oneOf(["large", "medium", "small"]),
    "slot": PropTypes.string,
    "spellCheck": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "src": PropTypes.string,
    "step": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "style": PropTypes.object,
    "suppressContentEditableWarning": PropTypes.bool,
    "suppressHydrationWarning": PropTypes.bool,
    "tabIndex": PropTypes.number,
    "textboxRef": PropTypes.object,
    "title": PropTypes.string,
    "tooltipPosition": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "translate": PropTypes.oneOf(["no", "yes"]),
    "transparent": PropTypes.bool,
    "typeof": PropTypes.string,
    "unselectable": PropTypes.oneOf(["off", "on"]),
    "validationIconId": PropTypes.string,
    "validationOnLabel": PropTypes.bool,
    "value": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.string), PropTypes.number, PropTypes.string]),
    "vocab": PropTypes.string,
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "width": PropTypes.oneOfType([PropTypes.number, PropTypes.string])
  };
}
SelectTextbox.displayName = "SelectTextbox";
export default SelectTextbox;