import React from "react";
import { CommonTextboxProps } from "../../textbox";
import { ValidationProps } from "../../../__internal__/validations";
import { CustomSelectChangeEvent } from "../simple-select/simple-select.component";
export interface FormInputPropTypes extends ValidationProps, Omit<CommonTextboxProps, "onClick" | "onChange"> {
    /** Breakpoint for adaptive label (inline labels change to top aligned). Enables the adaptive behaviour when set */
    adaptiveLabelBreakpoint?: number;
    /** Prop to specify the aria-label attribute of the component input */
    ariaLabel?: string;
    /** Prop to specify the aria-labeledby property of the component input */
    ariaLabelledby?: string;
    /** If true the Component will be focused when rendered */
    autoFocus?: boolean;
    /** If true, the component will be disabled */
    disabled?: boolean;
    /** Id attribute of the input element */
    id?: string;
    /** The width of the input as a percentage */
    inputWidth?: number;
    /** Label content */
    label?: string;
    /** A message that the Help component will display */
    labelHelp?: React.ReactNode;
    /** When true label is inline */
    labelInline?: boolean;
    /** Label width */
    labelWidth?: number;
    /** Name attribute of the input element */
    name?: string;
    /** Specify a callback triggered on blur */
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** Specify a callback triggered on change */
    onChange?: (ev: CustomSelectChangeEvent | React.ChangeEvent<HTMLInputElement>) => void;
    /** Specify a callback triggered on click */
    onClick?: (ev: React.MouseEvent<HTMLInputElement>) => void;
    /** Specify a callback triggered on focus */
    onFocus?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    /** pecify a callback triggered on keuyDown */
    onKeyDown?: (ev: React.KeyboardEvent<HTMLInputElement>) => void;
    /** Placeholder string to be displayed in input */
    placeholder?: string;
    /** Flag to configure component as mandatory */
    required?: boolean;
    /** If true, the component will be read-only */
    readOnly?: boolean;
    /** Size of an input */
    size?: "small" | "medium" | "large";
    /**
     * Id of the element containing the currently displayed value
     * to be read by voice readers
     * @private
     * @ignore
     */
    accessibilityLabelId?: string;
    /**
     * Label id passed from Select component
     * @private
     * @ignore
     *
     */
    labelId?: string;
    /** Flag to configure component as optional in Form */
    isOptional?: boolean;
}
export interface SelectTextboxProps extends FormInputPropTypes {
    /** Id attribute of the select list */
    "aria-controls"?: string;
    /** Value to be displayed in the Textbox */
    formattedValue?: string;
    /** If true, the input will be displayed */
    hasTextCursor?: boolean;
    /** If true, the list is displayed */
    isOpen?: boolean;
    /** Value of the Select Input */
    selectedValue?: string | Record<string, unknown> | string[] | Record<string, unknown>[];
    /** @private @ignore */
    textboxRef?: HTMLInputElement | null;
    /** @private @ignore */
    transparent?: boolean;
    /** @private @ignore */
    activeDescendantId?: string;
}
declare const SelectTextbox: React.ForwardRefExoticComponent<SelectTextboxProps & React.RefAttributes<HTMLInputElement>>;
export default SelectTextbox;
