import React from "react";
import { Side } from "@floating-ui/dom";
export interface SelectListProps {
    /** The ID for the parent <div> */
    id?: string;
    /** The Id of the label */
    labelId?: string;
    /** Child components (such as <Option>) */
    children?: React.ReactNode;
    /** DOM element to position the dropdown menu list relative to */
    anchorElement?: HTMLElement;
    /** A callback for when a child is selected */
    onSelect: (target: {
        text?: string;
        value?: string | Record<string, unknown>;
        id?: string;
        selectionType: string;
        selectionConfirmed: boolean;
    }) => void;
    /** A callback for when the list should be closed */
    onSelectListClose: () => void;
    /** Text value to highlight an option */
    filterText?: string;
    /** Value of option to be highlighted on component render */
    highlightedValue?: string | Record<string, unknown>;
    /** True for default text button or a Button Component to be rendered */
    listActionButton?: boolean | React.ReactNode;
    /** Maximum list height - defaults to 180 */
    listMaxHeight?: number;
    /** A callback for when the Action Button is triggered */
    onListAction?: (ev?: React.MouseEvent<HTMLButtonElement | HTMLAnchorElement>) => void;
    /** If true the loader animation is displayed below the last option */
    isLoading?: boolean;
    /** A callback that is triggered when a user scrolls to the bottom of the list */
    onListScrollBottom?: () => void;
    /** SelectList table header, should consist of multiple th elements. Works only in multiColumn mode */
    tableHeader?: React.ReactNode;
    /** When true component will work in multi column mode, children should consist of OptionRow components in this mode */
    multiColumn?: boolean;
    /** Data role for loader component */
    loaderDataRole?: string;
    /** Placement of the select list relative to the input element */
    listPlacement?: Side;
    /** Use the opposite list placement if the set placement does not fit */
    flipEnabled?: boolean;
    /** @private @ignore
     * Hides the list (with CSS display: none) if not set
     */
    isOpen?: boolean;
    /** array of selected values, if rendered as part of a MultiSelect */
    multiselectValues?: string[] | Record<string, unknown>[];
    /** Set this prop to enable a virtualised list of options. If it is not used then all options will be in the
     * DOM at all times, which may cause performance problems on very large lists */
    enableVirtualScroll?: boolean;
    /** The number of options to render into the DOM at once, either side of the currently-visible ones.
     * Higher values make for smoother scrolling but may impact performance.
     * Only used if the `enableVirtualScroll` prop is set. */
    virtualScrollOverscan?: number;
    /** @private @ignore A callback for when a mouseDown event occurs on the component */
    onMouseDown?: () => void;
}
declare const SelectList: React.ForwardRefExoticComponent<SelectListProps & React.RefAttributes<HTMLDivElement>>;
export default SelectList;
