import React from "react";
import { TagProps } from "../../../__internal__/utils/helpers/tags";
export interface OptionProps extends Omit<React.InputHTMLAttributes<HTMLLIElement>, "value" | "onSelect" | "onClick">, TagProps {
    /**
     * Unique identifier for the component.
     * Will use a randomly generated GUID if none is provided.
     */
    id?: string;
    /** The option's visible text, displayed within `<Textbox>` of `<Select>`, and used for filtering */
    text: string;
    /** Optional: alternative rendered content, displayed within `<SelectList>` of `<Select>` (eg: an icon, an image, etc) */
    children?: React.ReactNode;
    /** The option's invisible internal value */
    value: string | Record<string, unknown>;
    /** MultiSelect only - custom Pill border color - provide any color from palette or any valid css color value. */
    borderColor?: string;
    /** MultiSelect only - fill Pill background with color */
    fill?: boolean;
    /** If true, the component will be disabled */
    disabled?: boolean;
    /**
     * @private
     * @ignore
     * OnClick callback */
    onClick?: (value: string | Record<string, unknown>) => void;
    /**
     * @private
     * @ignore
     * OnSelect callback */
    onSelect?: (target?: {
        text?: string;
        value?: string | Record<string, unknown>;
        id?: string;
    }) => void;
    /**
     * @private
     * @ignore
     */
    index?: number;
}
declare const Option: React.ForwardRefExoticComponent<OptionProps & React.RefAttributes<HTMLLIElement>>;
export default Option;
