function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext, useRef } from "react";
import PropTypes from "prop-types";
import guid from "../../../__internal__/utils/helpers/guid";
import StyledOptionRow from "./option-row.style";
import SelectListContext from "../__internal__/select-list-context";
const OptionRow = /*#__PURE__*/React.forwardRef(({
  id,
  text,
  children,
  disabled,
  onSelect,
  value,
  index,
  hidden,
  style,
  ...rest
}, ref) => {
  const internalIdRef = useRef(id || guid());
  const handleClick = () => {
    if (disabled) {
      return;
    }
    onSelect?.({
      text,
      value,
      id: internalIdRef.current
    });
  };
  const selectListContext = useContext(SelectListContext);
  let isSelected = selectListContext.currentOptionsListIndex === index;
  if (selectListContext.multiselectValues) {
    isSelected = selectListContext.multiselectValues.includes(value);
  }
  return /*#__PURE__*/React.createElement(StyledOptionRow, _extends({
    id: internalIdRef.current,
    ref: ref,
    "aria-selected": isSelected,
    "aria-disabled": disabled,
    "data-component": "option-row",
    isDisabled: disabled,
    onClick: handleClick,
    isHighlighted: selectListContext.currentOptionsListIndex === index,
    role: "option",
    hidden: hidden,
    style: style
  }, rest), children);
});
if (process.env.NODE_ENV !== "production") {
  OptionRow.propTypes = {
    "children": PropTypes.node,
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "disabled": PropTypes.bool,
    "hidden": PropTypes.bool,
    "id": PropTypes.string,
    "index": PropTypes.number,
    "onSelect": PropTypes.func,
    "style": PropTypes.object,
    "text": PropTypes.string.isRequired,
    "value": PropTypes.oneOfType([PropTypes.object, PropTypes.string]).isRequired
  };
}
OptionRow.displayName = "OptionRow";
export default OptionRow;