import React from "react";
import { CSSProperties } from "styled-components";
import { TagProps } from "__internal__/utils/helpers/tags";
import { IconProps } from "../../icon";
export interface OptionGroupHeaderProps extends TagProps {
    /**
     * Unique identifier for the component.
     * Will use a randomly generated GUID if none is provided.
     */
    id?: string;
    /** Heading text */
    label: string;
    /** Any valid Carbon icon name */
    icon?: IconProps["type"];
    /**
     * @private
     * @ignore
     * object containing CSS styles to be passed to the underlying DOM element */
    style?: CSSProperties;
}
declare const OptionGroupHeader: React.ForwardRefExoticComponent<OptionGroupHeaderProps & React.RefAttributes<HTMLDivElement>>;
export default OptionGroupHeader;
