function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useEffect, useRef, useCallback, useMemo } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { filterOutStyledSystemSpacingProps } from "../../../style/utils";
import SelectTextbox from "../select-textbox";
import guid from "../../../__internal__/utils/helpers/guid";
import withFilter from "../utils/with-filter.hoc";
import SelectList from "../select-list/select-list.component";
import { StyledSelectPillContainer, StyledSelectMultiSelect, StyledAccessibilityLabelContainer } from "./multi-select.style";
import Pill from "../../pill";
import isExpectedOption from "../utils/is-expected-option";
import isExpectedValue from "../utils/is-expected-value";
import isNavigationKey from "../utils/is-navigation-key";
import Logger from "../../../__internal__/utils/logger";
import useStableCallback from "../../../hooks/__internal__/useStableCallback";
import useFormSpacing from "../../../hooks/__internal__/useFormSpacing";
import useInputAccessibility from "../../../hooks/__internal__/useInputAccessibility/useInputAccessibility";
let deprecateUncontrolledWarnTriggered = false;
const FilterableSelectList = withFilter(SelectList);
const MultiSelect = /*#__PURE__*/React.forwardRef(({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledby,
  value,
  defaultValue,
  id,
  label,
  name,
  disabled,
  readOnly,
  children,
  onOpen,
  onFilterChange: onFilterChangeProp,
  onChange,
  onClick,
  onFocus,
  onBlur,
  onKeyDown,
  openOnFocus = false,
  noResultsMessage,
  placeholder,
  isLoading,
  tableHeader,
  multiColumn,
  tooltipPosition,
  size,
  "data-component": dataComponent = "multiselect",
  "data-element": dataElement,
  "data-role": dataRole,
  listPlacement = "bottom",
  listMaxHeight,
  flipEnabled = true,
  wrapPillText = true,
  enableVirtualScroll,
  virtualScrollOverscan,
  isOptional,
  required,
  ...textboxProps
}, ref) => {
  const [activeDescendantId, setActiveDescendantId] = useState();
  const selectListId = useRef(guid());
  const accessibilityLabelId = useRef(guid());
  const containerRef = useRef(null);
  const listboxRef = useRef(null);
  const isInputFocused = useRef(false);
  const isClickTriggeredBySelect = useRef(false);
  const isMouseDownReported = useRef(false);
  const isMouseDownOnInput = useRef(false);
  const isControlled = useRef(value !== undefined);
  const [textboxRef, setTextboxRef] = useState();
  const [isOpen, setOpenState] = useState(false);
  const [textValue, setTextValue] = useState("");
  const [selectedValue, setSelectedValue] = useState(value || defaultValue || []);
  const [highlightedValue, setHighlightedValue] = useState("");
  const [filterText, setFilterText] = useState("");
  const [placeholderOverride, setPlaceholderOverride] = useState();
  const inputId = useRef(id || guid());
  const {
    labelId
  } = useInputAccessibility({
    id: inputId.current,
    label
  });
  const focusTimer = useRef(null);
  const actualValue = isControlled.current ? value : selectedValue;
  const componentIsUncontrolled = !isControlled || !onChange && defaultValue;
  if (!deprecateUncontrolledWarnTriggered && componentIsUncontrolled) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Multi Select` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  const setOpen = useCallback(() => {
    setOpenState(isAlreadyOpen => {
      if (!isAlreadyOpen && onOpen) {
        onOpen();
      }
      return true;
    });
  }, [onOpen]);
  const createCustomEvent = useCallback((newValue, selectionConfirmed) => {
    const customEvent = {
      target: {
        ...(name && {
          name
        }),
        ...(id && {
          id
        }),
        value: newValue
      },
      selectionConfirmed
    };
    return customEvent;
  }, [name, id]);

  /* generic value update function which can be used for both controlled and uncontrolled
   * components, both with and without onChange.
   * It accepts a function to update the value, which is assumed to be have no side effects and therefore
   * be safe to run more than once if needed. */
  const updateValue = useCallback((updateFunction, selectionConfirmed) => {
    const newValue = updateFunction(actualValue);
    // only call onChange if an option has been selected or deselected
    if (onChange && newValue.length !== actualValue?.length) {
      onChange(createCustomEvent(newValue, selectionConfirmed));
    }

    // no need to update selectedValue if the component is controlled: onChange should take care of updating the value
    if (!isControlled.current) {
      setSelectedValue(updateFunction);
    }
  }, [createCustomEvent, onChange, actualValue]);
  function findElementWithMatchingText(textToMatch, list) {
    return React.Children.toArray(list).find(child => {
      const {
        text
      } = child.props;
      return text?.toLowerCase().indexOf(textToMatch?.toLowerCase()) !== -1;
    });
  }
  const handleTextboxChange = useCallback(event => {
    const newValue = event.target.value;
    const match = findElementWithMatchingText(newValue, children);
    if (match) {
      setHighlightedValue(match.props.value);
    }
    setFilterText(newValue);
    setTextValue(newValue);
    setOpen();
  }, [children, setOpen]);
  const removeSelectedValue = useCallback(index => {
    isClickTriggeredBySelect.current = true;
    updateValue(previousValue => {
      if (!previousValue.length) {
        return previousValue;
      }
      const newValue = previousValue.slice(); // spreading does not work but slice does - see https://github.com/microsoft/TypeScript/issues/53670
      newValue.splice(index, 1);
      return newValue;
    }, true);
  }, [updateValue]);
  const handleTextboxKeydown = useCallback(event => {
    const {
      key
    } = event;
    const isDeleteKey = key === "Backspace" || key === "Delete";
    if (onKeyDown) {
      onKeyDown(event);
    }
    if (readOnly) {
      return;
    }
    if (!event.defaultPrevented && isNavigationKey(key)) {
      event.preventDefault();
      setOpen();
    }
    if (isDeleteKey && (filterText === "" || textValue === "")) {
      removeSelectedValue(-1);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [onKeyDown, readOnly, filterText, textValue, setOpen, removeSelectedValue]);
  const accessibilityLabel = useMemo(() => {
    return actualValue && actualValue.length ? React.Children.map(children, child => {
      return /*#__PURE__*/React.isValidElement(child) && actualValue.includes(child.props.value) ? child.props.text : false;
    })?.filter(child => child).reduce((acc, item) => {
      return acc ? `${acc}, ${item}` : item;
    }, "") : null;
  }, [children, actualValue]);
  const handleGlobalClick = useCallback(event => {
    isMouseDownReported.current = false;
    if (!isOpen) {
      return;
    }
    const notInContainer = containerRef.current && !containerRef.current.contains(event.target);
    const notInList = listboxRef.current && !listboxRef.current.contains(event.target);
    if (notInContainer && notInList && !isClickTriggeredBySelect.current) {
      setTextValue("");
      setFilterText("");
      setHighlightedValue("");
      setOpenState(false);
    }
    isClickTriggeredBySelect.current = false;
  }, [isOpen]);
  const mapValuesToPills = useMemo(() => {
    const canDelete = !disabled && !readOnly;
    if (!actualValue?.length) {
      return "";
    }
    return actualValue.map((singleValue, index) => {
      const matchingOption = React.Children.toArray(children).find(child => /*#__PURE__*/React.isValidElement(child) && isExpectedOption(child, singleValue));
      let pillProps = {};
      if (!matchingOption) {
        return null;
      }

      /* istanbul ignore else */
      if ( /*#__PURE__*/React.isValidElement(matchingOption)) {
        pillProps = {
          title: matchingOption.props.text,
          fill: matchingOption.props.fill,
          borderColor: matchingOption.props.borderColor
        };
      }
      const title = pillProps.title || /* istanbul ignore next */"";
      const key = title + ( /*#__PURE__*/React.isValidElement(matchingOption) && matchingOption.props.value || /* istanbul ignore next */index);
      return /*#__PURE__*/React.createElement(StyledSelectPillContainer, {
        key: key
      }, /*#__PURE__*/React.createElement(Pill, _extends({
        onDelete: canDelete ? () => removeSelectedValue(index) : undefined,
        wrapText: wrapPillText
      }, pillProps), title));
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [children, disabled, readOnly, actualValue]);
  useEffect(() => {
    const modeSwitchedMessage = "Input elements should not switch from uncontrolled to controlled (or vice versa). " + "Decide between using a controlled or uncontrolled input element for the lifetime of the component";
    const onChangeMissingMessage = "onChange prop required when using a controlled input element";
    !(isControlled.current === (value !== undefined)) ? process.env.NODE_ENV !== "production" ? invariant(false, modeSwitchedMessage) : invariant(false) : void 0;
    !(!isControlled.current || isControlled.current && onChange) ? process.env.NODE_ENV !== "production" ? invariant(false, onChangeMissingMessage) : invariant(false) : void 0;
  }, [value, onChange]);

  // removes placeholder when a value is present
  useEffect(() => {
    const hasValue = value?.length;
    const hasSelectedValue = actualValue?.length;
    if (hasValue || hasSelectedValue) {
      setPlaceholderOverride(" ");
    } else {
      setPlaceholderOverride(placeholder);
    }
  }, [value, actualValue, placeholder]);
  useEffect(() => {
    const clickEvent = "click";
    window.addEventListener(clickEvent, handleGlobalClick);
    return function cleanup() {
      window.removeEventListener(clickEvent, handleGlobalClick);
    };
  }, [handleGlobalClick]);
  const onFilterChange = useStableCallback(onFilterChangeProp);
  const isFirstRender = useRef(true);
  useEffect(() => {
    if (onFilterChange && !isFirstRender.current) {
      onFilterChange(filterText);
    }
  }, [onFilterChange, filterText]);
  useEffect(() => {
    isFirstRender.current = false;
  }, []);
  function handleTextboxClick(event) {
    isMouseDownReported.current = false;
    if (onClick) {
      onClick(event);
    }
  }
  function handleDropdownIconClick(event) {
    isMouseDownReported.current = false;
    if (onClick) {
      onClick(event);
    }
    setOpenState(isAlreadyOpen => {
      if (isAlreadyOpen) {
        setFilterText("");
        return false;
      }
      if (onOpen) {
        onOpen();
      }
      return true;
    });
  }
  function handleTextboxBlur(event) {
    isMouseDownOnInput.current = false;
    if (isMouseDownReported.current) {
      return;
    }
    isInputFocused.current = false;
    if (onBlur) {
      onBlur(event);
    }
  }
  function handleTextboxMouseDown(event) {
    isMouseDownReported.current = true;
    if (event.target.dataset.element === "input") {
      isMouseDownOnInput.current = true;
    }
  }
  function handleListMouseDown() {
    isMouseDownReported.current = true;
  }
  function handleTextboxFocus(event) {
    const triggerFocus = () => onFocus?.(event);
    if (openOnFocus) {
      if (focusTimer.current) {
        clearTimeout(focusTimer.current);
      }

      // we need to use a timeout here as there is a race condition when rendered in a modal
      // whereby the select list isn't visible when the select is auto focused straight away
      focusTimer.current = setTimeout(() => {
        setOpenState(isAlreadyOpen => {
          if (isAlreadyOpen) {
            return true;
          }
          if (onOpen) {
            onOpen();
          }
          if (onFocus && !isInputFocused.current) {
            triggerFocus();
            isInputFocused.current = true;
          }
          if (isMouseDownReported.current && !isMouseDownOnInput.current) {
            return false;
          }
          return true;
        });
      });
    } else if (onFocus && !isInputFocused.current) {
      triggerFocus();
      isInputFocused.current = true;
    }
  }
  const onSelectOption = useCallback(optionData => {
    const {
      value: newValue,
      selectionType,
      id: selectedOptionId,
      selectionConfirmed
    } = optionData;
    if (selectionType === "navigationKey") {
      setHighlightedValue(newValue);
      setActiveDescendantId(selectedOptionId);
      return;
    }
    if (selectionType === "click") {
      isClickTriggeredBySelect.current = true;
    }
    setTextValue("");
    const isAlreadySelected = actualValue?.findIndex(val => isExpectedValue(val, newValue)) !== -1;
    textboxRef?.focus();
    isMouseDownReported.current = false;
    updateValue(previousValue => {
      if (isAlreadySelected) {
        return previousValue;
      }
      return [...previousValue, newValue];
    }, selectionConfirmed);
  }, [textboxRef, actualValue, updateValue]);
  const onSelectListClose = useCallback(() => {
    setOpenState(false);
    setFilterText("");
  }, []);
  const assignInput = useCallback(element => {
    setTextboxRef(element);
    if (!ref) {
      return;
    }
    if (typeof ref === "function") {
      ref(element);
    } else {
      ref.current = element;
    }
  }, [ref]);
  function getTextboxProps() {
    return {
      id: inputId.current,
      name,
      disabled,
      label,
      readOnly,
      placeholder: placeholderOverride,
      leftChildren: mapValuesToPills,
      ref: assignInput,
      formattedValue: textValue,
      selectedValue: actualValue,
      onClick: handleTextboxClick,
      onMouseDown: handleTextboxMouseDown,
      onFocus: handleTextboxFocus,
      onBlur: handleTextboxBlur,
      iconOnClick: handleDropdownIconClick,
      iconOnMouseDown: handleTextboxMouseDown,
      onKeyDown: handleTextboxKeydown,
      onChange: handleTextboxChange,
      tooltipPosition,
      size,
      required,
      isOptional,
      ...filterOutStyledSystemSpacingProps(textboxProps)
    };
  }
  const selectList = /*#__PURE__*/React.createElement(FilterableSelectList, {
    ref: listboxRef,
    id: selectListId.current,
    labelId: labelId,
    anchorElement: textboxRef?.parentElement || undefined,
    onSelect: onSelectOption,
    onSelectListClose: onSelectListClose,
    onMouseDown: handleListMouseDown,
    filterText: filterText.trim(),
    highlightedValue: highlightedValue,
    noResultsMessage: noResultsMessage,
    isLoading: isLoading,
    tableHeader: tableHeader,
    multiColumn: multiColumn,
    listPlacement: listPlacement,
    listMaxHeight: listMaxHeight,
    flipEnabled: flipEnabled,
    loaderDataRole: "multi-select-list-loader",
    multiselectValues: actualValue,
    isOpen: isOpen,
    enableVirtualScroll: enableVirtualScroll,
    virtualScrollOverscan: virtualScrollOverscan
  }, children);
  const marginProps = useFormSpacing(textboxProps);
  return /*#__PURE__*/React.createElement(StyledSelectMultiSelect, _extends({
    disabled: disabled,
    readOnly: readOnly,
    hasTextCursor: true,
    size: size,
    "data-component": dataComponent,
    "data-role": dataRole,
    "data-element": dataElement,
    isOpen: isOpen
  }, marginProps), /*#__PURE__*/React.createElement("div", {
    ref: containerRef
  }, /*#__PURE__*/React.createElement(StyledAccessibilityLabelContainer, {
    "data-element": "accessibility-label",
    id: accessibilityLabelId.current
  }, accessibilityLabel), /*#__PURE__*/React.createElement(SelectTextbox, _extends({
    accessibilityLabelId: accessibilityLabelId.current,
    activeDescendantId: activeDescendantId,
    "aria-controls": selectListId.current,
    ariaLabel: ariaLabel,
    ariaLabelledby: ariaLabelledby,
    hasTextCursor: true,
    isOpen: isOpen,
    labelId: labelId,
    textboxRef: textboxRef
  }, getTextboxProps()))), selectList);
});
if (process.env.NODE_ENV !== "production") {
  MultiSelect.propTypes = {
    "about": PropTypes.string,
    "accept": PropTypes.string,
    "accessibilityLabelId": PropTypes.string,
    "accessKey": PropTypes.string,
    "adaptiveLabelBreakpoint": PropTypes.number,
    "align": PropTypes.oneOf(["left", "right"]),
    "alt": PropTypes.string,
    "aria-activedescendant": PropTypes.string,
    "aria-atomic": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-autocomplete": PropTypes.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-checked": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-colcount": PropTypes.number,
    "aria-colindex": PropTypes.number,
    "aria-colspan": PropTypes.number,
    "aria-controls": PropTypes.string,
    "aria-current": PropTypes.oneOfType([PropTypes.oneOf(["date", "false", "location", "page", "step", "time", "true"]), PropTypes.bool]),
    "aria-describedby": PropTypes.string,
    "aria-details": PropTypes.string,
    "aria-disabled": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-dropeffect": PropTypes.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": PropTypes.string,
    "aria-expanded": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-flowto": PropTypes.string,
    "aria-grabbed": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-haspopup": PropTypes.oneOfType([PropTypes.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), PropTypes.bool]),
    "aria-hidden": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-invalid": PropTypes.oneOfType([PropTypes.oneOf(["false", "grammar", "spelling", "true"]), PropTypes.bool]),
    "aria-keyshortcuts": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "aria-level": PropTypes.number,
    "aria-live": PropTypes.oneOf(["assertive", "off", "polite"]),
    "aria-modal": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiline": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiselectable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-orientation": PropTypes.oneOf(["horizontal", "vertical"]),
    "aria-owns": PropTypes.string,
    "aria-placeholder": PropTypes.string,
    "aria-posinset": PropTypes.number,
    "aria-pressed": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-readonly": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-relevant": PropTypes.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-roledescription": PropTypes.string,
    "aria-rowcount": PropTypes.number,
    "aria-rowindex": PropTypes.number,
    "aria-rowspan": PropTypes.number,
    "aria-selected": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-setsize": PropTypes.number,
    "aria-sort": PropTypes.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": PropTypes.number,
    "aria-valuemin": PropTypes.number,
    "aria-valuenow": PropTypes.number,
    "aria-valuetext": PropTypes.string,
    "ariaDescribedBy": PropTypes.string,
    "ariaLabel": PropTypes.string,
    "ariaLabelledby": PropTypes.string,
    "as": PropTypes.elementType,
    "autoCapitalize": PropTypes.string,
    "autoComplete": PropTypes.string,
    "autoCorrect": PropTypes.string,
    "autoFocus": PropTypes.bool,
    "autoSave": PropTypes.string,
    "capture": PropTypes.oneOfType([PropTypes.oneOf(["environment", "user"]), PropTypes.bool]),
    "checked": PropTypes.bool,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "color": PropTypes.string,
    "content": PropTypes.string,
    "contentEditable": PropTypes.oneOfType([PropTypes.oneOf(["false", "inherit", "true"]), PropTypes.bool]),
    "contextMenu": PropTypes.string,
    "dangerouslySetInnerHTML": PropTypes.shape({
      "__html": PropTypes.oneOfType([PropTypes.object, PropTypes.string]).isRequired
    }),
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "datatype": PropTypes.string,
    "defaultChecked": PropTypes.bool,
    "defaultValue": PropTypes.arrayOf(PropTypes.string),
    "deferTimeout": PropTypes.number,
    "dir": PropTypes.string,
    "disabled": PropTypes.bool,
    "draggable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "enableVirtualScroll": PropTypes.bool,
    "enterKeyHint": PropTypes.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "fieldHelp": PropTypes.node,
    "flipEnabled": PropTypes.bool,
    "form": PropTypes.string,
    "formAction": PropTypes.string,
    "formattedValue": PropTypes.string,
    "formEncType": PropTypes.string,
    "formMethod": PropTypes.string,
    "formNoValidate": PropTypes.bool,
    "formTarget": PropTypes.string,
    "height": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "helpAriaLabel": PropTypes.string,
    "hidden": PropTypes.bool,
    "iconOnClick": PropTypes.func,
    "iconOnMouseDown": PropTypes.func,
    "iconTabIndex": PropTypes.number,
    "id": PropTypes.string,
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "inlist": PropTypes.any,
    "inputHint": PropTypes.string,
    "inputIcon": PropTypes.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "marker", "message", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]),
    "inputMode": PropTypes.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputWidth": PropTypes.number,
    "is": PropTypes.string,
    "isLoading": PropTypes.bool,
    "isOptional": PropTypes.bool,
    "itemID": PropTypes.string,
    "itemProp": PropTypes.string,
    "itemRef": PropTypes.string,
    "itemScope": PropTypes.bool,
    "itemType": PropTypes.string,
    "label": PropTypes.string,
    "labelAlign": PropTypes.oneOf(["left", "right"]),
    "labelHelp": PropTypes.node,
    "labelId": PropTypes.string,
    "labelInline": PropTypes.bool,
    "labelSpacing": PropTypes.oneOf([1, 2]),
    "labelWidth": PropTypes.number,
    "lang": PropTypes.string,
    "leftChildren": PropTypes.node,
    "list": PropTypes.string,
    "listMaxHeight": PropTypes.number,
    "listPlacement": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "max": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "maxLength": PropTypes.number,
    "maxWidth": PropTypes.string,
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "min": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "minLength": PropTypes.number,
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "multiColumn": PropTypes.bool,
    "multiple": PropTypes.bool,
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string,
    "nonce": PropTypes.string,
    "noResultsMessage": PropTypes.string,
    "onAbort": PropTypes.func,
    "onAbortCapture": PropTypes.func,
    "onAnimationEnd": PropTypes.func,
    "onAnimationEndCapture": PropTypes.func,
    "onAnimationIteration": PropTypes.func,
    "onAnimationIterationCapture": PropTypes.func,
    "onAnimationStart": PropTypes.func,
    "onAnimationStartCapture": PropTypes.func,
    "onAuxClick": PropTypes.func,
    "onAuxClickCapture": PropTypes.func,
    "onBeforeInput": PropTypes.func,
    "onBeforeInputCapture": PropTypes.func,
    "onBlur": PropTypes.func,
    "onBlurCapture": PropTypes.func,
    "onCanPlay": PropTypes.func,
    "onCanPlayCapture": PropTypes.func,
    "onCanPlayThrough": PropTypes.func,
    "onCanPlayThroughCapture": PropTypes.func,
    "onChange": PropTypes.func,
    "onChangeCapture": PropTypes.func,
    "onChangeDeferred": PropTypes.func,
    "onClick": PropTypes.func,
    "onClickCapture": PropTypes.func,
    "onCompositionEnd": PropTypes.func,
    "onCompositionEndCapture": PropTypes.func,
    "onCompositionStart": PropTypes.func,
    "onCompositionStartCapture": PropTypes.func,
    "onCompositionUpdate": PropTypes.func,
    "onCompositionUpdateCapture": PropTypes.func,
    "onContextMenu": PropTypes.func,
    "onContextMenuCapture": PropTypes.func,
    "onCopy": PropTypes.func,
    "onCopyCapture": PropTypes.func,
    "onCut": PropTypes.func,
    "onCutCapture": PropTypes.func,
    "onDoubleClick": PropTypes.func,
    "onDoubleClickCapture": PropTypes.func,
    "onDrag": PropTypes.func,
    "onDragCapture": PropTypes.func,
    "onDragEnd": PropTypes.func,
    "onDragEndCapture": PropTypes.func,
    "onDragEnter": PropTypes.func,
    "onDragEnterCapture": PropTypes.func,
    "onDragExit": PropTypes.func,
    "onDragExitCapture": PropTypes.func,
    "onDragLeave": PropTypes.func,
    "onDragLeaveCapture": PropTypes.func,
    "onDragOver": PropTypes.func,
    "onDragOverCapture": PropTypes.func,
    "onDragStart": PropTypes.func,
    "onDragStartCapture": PropTypes.func,
    "onDrop": PropTypes.func,
    "onDropCapture": PropTypes.func,
    "onDurationChange": PropTypes.func,
    "onDurationChangeCapture": PropTypes.func,
    "onEmptied": PropTypes.func,
    "onEmptiedCapture": PropTypes.func,
    "onEncrypted": PropTypes.func,
    "onEncryptedCapture": PropTypes.func,
    "onEnded": PropTypes.func,
    "onEndedCapture": PropTypes.func,
    "onError": PropTypes.func,
    "onErrorCapture": PropTypes.func,
    "onFilterChange": PropTypes.func,
    "onFocus": PropTypes.func,
    "onFocusCapture": PropTypes.func,
    "onGotPointerCapture": PropTypes.func,
    "onGotPointerCaptureCapture": PropTypes.func,
    "onInput": PropTypes.func,
    "onInputCapture": PropTypes.func,
    "onInvalid": PropTypes.func,
    "onInvalidCapture": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onKeyDownCapture": PropTypes.func,
    "onKeyPress": PropTypes.func,
    "onKeyPressCapture": PropTypes.func,
    "onKeyUp": PropTypes.func,
    "onKeyUpCapture": PropTypes.func,
    "onLoad": PropTypes.func,
    "onLoadCapture": PropTypes.func,
    "onLoadedData": PropTypes.func,
    "onLoadedDataCapture": PropTypes.func,
    "onLoadedMetadata": PropTypes.func,
    "onLoadedMetadataCapture": PropTypes.func,
    "onLoadStart": PropTypes.func,
    "onLoadStartCapture": PropTypes.func,
    "onLostPointerCapture": PropTypes.func,
    "onLostPointerCaptureCapture": PropTypes.func,
    "onMouseDown": PropTypes.func,
    "onMouseDownCapture": PropTypes.func,
    "onMouseEnter": PropTypes.func,
    "onMouseLeave": PropTypes.func,
    "onMouseMove": PropTypes.func,
    "onMouseMoveCapture": PropTypes.func,
    "onMouseOut": PropTypes.func,
    "onMouseOutCapture": PropTypes.func,
    "onMouseOver": PropTypes.func,
    "onMouseOverCapture": PropTypes.func,
    "onMouseUp": PropTypes.func,
    "onMouseUpCapture": PropTypes.func,
    "onOpen": PropTypes.func,
    "onPaste": PropTypes.func,
    "onPasteCapture": PropTypes.func,
    "onPause": PropTypes.func,
    "onPauseCapture": PropTypes.func,
    "onPlay": PropTypes.func,
    "onPlayCapture": PropTypes.func,
    "onPlaying": PropTypes.func,
    "onPlayingCapture": PropTypes.func,
    "onPointerCancel": PropTypes.func,
    "onPointerCancelCapture": PropTypes.func,
    "onPointerDown": PropTypes.func,
    "onPointerDownCapture": PropTypes.func,
    "onPointerEnter": PropTypes.func,
    "onPointerEnterCapture": PropTypes.func,
    "onPointerLeave": PropTypes.func,
    "onPointerLeaveCapture": PropTypes.func,
    "onPointerMove": PropTypes.func,
    "onPointerMoveCapture": PropTypes.func,
    "onPointerOut": PropTypes.func,
    "onPointerOutCapture": PropTypes.func,
    "onPointerOver": PropTypes.func,
    "onPointerOverCapture": PropTypes.func,
    "onPointerUp": PropTypes.func,
    "onPointerUpCapture": PropTypes.func,
    "onProgress": PropTypes.func,
    "onProgressCapture": PropTypes.func,
    "onRateChange": PropTypes.func,
    "onRateChangeCapture": PropTypes.func,
    "onReset": PropTypes.func,
    "onResetCapture": PropTypes.func,
    "onScroll": PropTypes.func,
    "onScrollCapture": PropTypes.func,
    "onSeeked": PropTypes.func,
    "onSeekedCapture": PropTypes.func,
    "onSeeking": PropTypes.func,
    "onSeekingCapture": PropTypes.func,
    "onSelect": PropTypes.func,
    "onSelectCapture": PropTypes.func,
    "onStalled": PropTypes.func,
    "onStalledCapture": PropTypes.func,
    "onSubmit": PropTypes.func,
    "onSubmitCapture": PropTypes.func,
    "onSuspend": PropTypes.func,
    "onSuspendCapture": PropTypes.func,
    "onTimeUpdate": PropTypes.func,
    "onTimeUpdateCapture": PropTypes.func,
    "onTouchCancel": PropTypes.func,
    "onTouchCancelCapture": PropTypes.func,
    "onTouchEnd": PropTypes.func,
    "onTouchEndCapture": PropTypes.func,
    "onTouchMove": PropTypes.func,
    "onTouchMoveCapture": PropTypes.func,
    "onTouchStart": PropTypes.func,
    "onTouchStartCapture": PropTypes.func,
    "onTransitionEnd": PropTypes.func,
    "onTransitionEndCapture": PropTypes.func,
    "onVolumeChange": PropTypes.func,
    "onVolumeChangeCapture": PropTypes.func,
    "onWaiting": PropTypes.func,
    "onWaitingCapture": PropTypes.func,
    "onWheel": PropTypes.func,
    "onWheelCapture": PropTypes.func,
    "openOnFocus": PropTypes.bool,
    "pattern": PropTypes.string,
    "placeholder": PropTypes.string,
    "prefix": PropTypes.string,
    "property": PropTypes.string,
    "radioGroup": PropTypes.string,
    "readOnly": PropTypes.bool,
    "rel": PropTypes.string,
    "required": PropTypes.bool,
    "resource": PropTypes.string,
    "results": PropTypes.number,
    "rev": PropTypes.string,
    "reverse": PropTypes.bool,
    "role": PropTypes.oneOfType([PropTypes.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "security": PropTypes.string,
    "size": PropTypes.oneOf(["large", "medium", "small"]),
    "slot": PropTypes.string,
    "spellCheck": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "src": PropTypes.string,
    "step": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "style": PropTypes.object,
    "suppressContentEditableWarning": PropTypes.bool,
    "suppressHydrationWarning": PropTypes.bool,
    "tabIndex": PropTypes.number,
    "tableHeader": PropTypes.node,
    "title": PropTypes.string,
    "tooltipPosition": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "translate": PropTypes.oneOf(["no", "yes"]),
    "typeof": PropTypes.string,
    "unselectable": PropTypes.oneOf(["off", "on"]),
    "validationIconId": PropTypes.string,
    "validationOnLabel": PropTypes.bool,
    "value": PropTypes.arrayOf(PropTypes.string),
    "virtualScrollOverscan": PropTypes.number,
    "vocab": PropTypes.string,
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "width": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "wrapPillText": PropTypes.bool
  };
}
export { MultiSelect };
export default MultiSelect;