import React from "react";
import PropTypes from "prop-types";
import StyledListActionButtonWrapper from "./list-action-button.style";
import useLocale from "../../../hooks/__internal__/useLocale";
import Button from "../../button";
const ListActionButton = /*#__PURE__*/React.forwardRef(({
  listActionButton,
  onListAction
}, ref) => {
  const l = useLocale();
  function renderListActionButton() {
    if (!listActionButton || listActionButton === true) {
      return /*#__PURE__*/React.createElement(Button, {
        ref: ref,
        onClick: onListAction,
        iconType: "add",
        iconPosition: "after"
      }, l.select.actionButtonText());
    }

    // istanbul ignore if
    if (! /*#__PURE__*/React.isValidElement(listActionButton)) {
      return listActionButton;
    }
    return /*#__PURE__*/React.cloneElement(listActionButton, {
      ref,
      onClick: onListAction
    });
  }
  return /*#__PURE__*/React.createElement(StyledListActionButtonWrapper, null, renderListActionButton());
});
if (process.env.NODE_ENV !== "production") {
  ListActionButton.propTypes = {
    "listActionButton": PropTypes.node,
    "onListAction": PropTypes.func
  };
}
ListActionButton.displayName = "ListActionButton";
export default ListActionButton;