function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useEffect, useRef, useCallback } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { filterOutStyledSystemSpacingProps } from "../../../style/utils";
import SelectTextbox from "../select-textbox";
import guid from "../../../__internal__/utils/helpers/guid";
import withFilter from "../utils/with-filter.hoc";
import isEqual from "lodash/isEqual";
import StyledSelect from "../select.style";
import SelectList from "../select-list/select-list.component";
import isExpectedOption from "../utils/is-expected-option";
import isNavigationKey from "../utils/is-navigation-key";
import Logger from "../../../__internal__/utils/logger";
import useStableCallback from "../../../hooks/__internal__/useStableCallback";
import useFormSpacing from "../../../hooks/__internal__/useFormSpacing";
import useInputAccessibility from "../../../hooks/__internal__/useInputAccessibility/useInputAccessibility";
let deprecateUncontrolledWarnTriggered = false;
const FilterableSelectList = withFilter(SelectList);
const FilterableSelect = /*#__PURE__*/React.forwardRef(({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledby,
  value,
  defaultValue,
  id,
  name,
  label,
  children,
  onOpen: onOpenProp,
  onChange,
  onFilterChange: onFilterChangeProp,
  onClick,
  onKeyDown,
  onFocus,
  onBlur,
  openOnFocus,
  noResultsMessage,
  listActionButton,
  listMaxHeight,
  onListAction,
  isLoading,
  disabled,
  readOnly,
  onListScrollBottom,
  tableHeader,
  multiColumn,
  "data-component": dataComponent = "filterable-select",
  "data-element": dataElement,
  "data-role": dataRole,
  tooltipPosition,
  listPlacement = "bottom",
  flipEnabled = true,
  enableVirtualScroll,
  virtualScrollOverscan,
  disableDefaultFiltering = false,
  isOptional,
  required,
  ...textboxProps
}, ref) => {
  const [activeDescendantId, setActiveDescendantId] = useState();
  const selectListId = useRef(guid());
  const containerRef = useRef(null);
  const listboxRef = useRef(null);
  const isControlled = useRef(value !== undefined);
  const isMouseDownReported = useRef(false);
  const isInputFocused = useRef(false);
  const isMouseDownOnInput = useRef(false);
  const [textboxRef, setTextboxRef] = useState();
  const [isOpen, setOpen] = useState(false);
  const [textValue, setTextValue] = useState("");
  const [selectedValue, setSelectedValue] = useState(value || defaultValue || "");
  const [highlightedValue, setHighlightedValue] = useState("");
  const [filterText, setFilterText] = useState("");
  const inputId = useRef(id || guid());
  const {
    labelId
  } = useInputAccessibility({
    id: inputId.current,
    label
  });
  const focusTimer = useRef(null);
  const openOnFocusFlagBlock = useRef(false);
  const componentIsUncontrolled = !isControlled || !onChange && defaultValue;
  if (!deprecateUncontrolledWarnTriggered && componentIsUncontrolled) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Filterable Select` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  const createCustomEvent = useCallback((newValue, selectionConfirmed) => {
    const customEvent = {
      target: {
        ...(name && {
          name
        }),
        ...(id && {
          id
        }),
        value: newValue
      },
      selectionConfirmed
    };
    return customEvent;
  }, [name, id]);
  const triggerChange = useCallback((newValue, selectionConfirmed) => {
    if (onChange) {
      onChange(createCustomEvent(newValue, selectionConfirmed));
    }
  }, [onChange, createCustomEvent]);
  function findElementWithMatchingText(textToMatch, list) {
    return React.Children.toArray(list).find(child => {
      const {
        text
      } = child.props;
      return text && text.toLowerCase() === textToMatch.toLowerCase();
    });
  }
  const updateValues = useCallback((newFilterText, isDeleteEvent) => {
    setSelectedValue(previousValue => {
      const trimmed = newFilterText.trimStart();
      const match = findElementWithMatchingText(trimmed, children);
      const isFilterCleared = isDeleteEvent && !newFilterText.length;
      if (isFilterCleared || (match && match.props && match.props.disabled)) {
        setTextValue(newFilterText);
        triggerChange("", false);
        return "";
      }
      if (match === undefined) {
        setTextValue(newFilterText);
        return previousValue;
      }
      if (trimmed.length) {
        triggerChange(match.props.value, false);
      }
      if (isDeleteEvent) {
        setTextValue(newFilterText);
        return match.props.value;
      }
      if (trimmed.length && match.props.text?.toLowerCase().startsWith(trimmed.toLowerCase())) {
        setTextValue(match.props.text);
      } else {
        setTextValue(newFilterText);
      }
      if (isControlled.current) {
        return previousValue;
      }
      setHighlightedValue(match.props.value);
      return match.props.value;
    });
  }, [children, triggerChange]);
  const setMatchingText = useCallback((newValue, isClosing = false) => {
    const matchingOption = React.Children.toArray(children).find(child => /*#__PURE__*/React.isValidElement(child) && isExpectedOption(child, newValue));
    if (!matchingOption || matchingOption.props.text === undefined) {
      setTextValue(filterText || "");
    } else if (isClosing || matchingOption.props.text?.toLowerCase().startsWith(filterText?.toLowerCase().trim())) {
      setTextValue(matchingOption.props.text);
    }
  }, [children, filterText]);
  const handleTextboxChange = useCallback(event => {
    const newValue = event.target.value;
    const isDeleteEvent = event.nativeEvent.inputType === "deleteContentBackward" || event.nativeEvent.inputType === "deleteContentForward" || event.nativeEvent.inputType === "delete";
    updateValues(newValue, isDeleteEvent);
    setFilterText(newValue);
    setOpen(true);
  }, [updateValues]);
  const fillLastFilterCharacter = useCallback(key => {
    setFilterText(previousFilterText => {
      if (previousFilterText?.length === textValue?.length - 1 && key === textValue.slice(-1)) {
        return textValue;
      }
      return previousFilterText;
    });
  }, [textValue]);
  const handleTextboxKeydown = useCallback(event => {
    const {
      key
    } = event;
    if (onKeyDown) {
      onKeyDown(event);
    }
    if (readOnly) {
      return;
    }
    if (!event.defaultPrevented && isNavigationKey(key)) {
      event.preventDefault();
      setOpen(true);
    }
    fillLastFilterCharacter(key);
  }, [fillLastFilterCharacter, onKeyDown, readOnly]);
  const valueToUse = isControlled.current ? value : selectedValue;
  const handleGlobalClick = useCallback(event => {
    const notInContainer = containerRef.current && !containerRef.current.contains(event.target);
    const notInList = listboxRef.current && !listboxRef.current.contains(event.target);
    isMouseDownReported.current = false;
    if (notInContainer && notInList) {
      setMatchingText(valueToUse, true);
      setOpen(false);
    }
  }, [setMatchingText, valueToUse]);
  useEffect(() => {
    const modeSwitchedMessage = "Input elements should not switch from uncontrolled to controlled (or vice versa). " + "Decide between using a controlled or uncontrolled input element for the lifetime of the component";
    const onChangeMissingMessage = "onChange prop required when using a controlled input element";
    !(isControlled.current === (value !== undefined)) ? process.env.NODE_ENV !== "production" ? invariant(false, modeSwitchedMessage) : invariant(false) : void 0;
    !(!isControlled.current || isControlled.current && onChange) ? process.env.NODE_ENV !== "production" ? invariant(false, onChangeMissingMessage) : invariant(false) : void 0;
    if (isControlled.current) {
      setSelectedValue(prevValue => {
        if (value && !isEqual(prevValue, value)) {
          setMatchingText(value);
        }
        return value;
      });
      setHighlightedValue(value);
    } else {
      if (textValue !== selectedValue) {
        setMatchingText(selectedValue);
      }
      if (highlightedValue !== selectedValue) {
        setHighlightedValue(selectedValue);
      }
    }
    // prevent value update on filter change
    // selectedValue and highlightedValue omitted from deps, only want uncontrolled change if onChange/children update
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [value, onChange, children]);
  const onOpen = useStableCallback(onOpenProp);
  useEffect(() => {
    if (!isOpen) {
      setFilterText("");
    } else if (onOpen) {
      onOpen();
    }
  }, [onOpen, isOpen]);
  useEffect(() => {
    const hasListActionButton = listActionButton !== undefined;
    const onListActionMissingMessage = "onListAction prop required when using listActionButton prop";
    !(!hasListActionButton || hasListActionButton && onListAction) ? process.env.NODE_ENV !== "production" ? invariant(false, onListActionMissingMessage) : invariant(false) : void 0;
  }, [listActionButton, onListAction]);
  useEffect(() => {
    if (isControlled.current) {
      setMatchingText(value);
    }
    // update text value only when children are changing
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [value, children]);
  const onFilterChange = useStableCallback(onFilterChangeProp);
  const isFirstRender = useRef(true);
  useEffect(() => {
    if (onFilterChange && !isFirstRender.current) {
      onFilterChange(filterText);
    }
  }, [onFilterChange, filterText]);
  useEffect(() => {
    isFirstRender.current = false;
  }, []);
  useEffect(() => {
    const clickEvent = "click";
    window.addEventListener(clickEvent, handleGlobalClick);
    return function cleanup() {
      window.removeEventListener(clickEvent, handleGlobalClick);
    };
  }, [handleGlobalClick]);
  useEffect(() => {
    const trimmed = filterText?.trimStart();
    const textStartsWithFilter = textValue?.toLowerCase().startsWith(trimmed.toLowerCase());
    const isTextboxActive = !disabled && !readOnly;
    if (isTextboxActive && textboxRef && trimmed.length && textValue?.length > trimmed.length && textStartsWithFilter) {
      textboxRef.selectionStart = trimmed.length;
    }
  }, [textValue, filterText, textboxRef, disabled, readOnly]);
  const onSelectOption = useCallback(optionData => {
    const {
      id: selectedOptionId,
      text,
      value: newValue = "",
      selectionType,
      selectionConfirmed
    } = optionData;
    if (selectionType === "tab") {
      setOpen(false);
      textboxRef?.focus();
      return;
    }
    if (!isControlled.current) {
      setSelectedValue(newValue);
      setHighlightedValue(newValue);
    }
    setTextValue(text || /* istanbul ignore next */"");
    triggerChange(newValue, !!selectionConfirmed);
    setActiveDescendantId(selectedOptionId);
    if (selectionType !== "navigationKey") {
      openOnFocusFlagBlock.current = !!openOnFocus;
      setOpen(false);
      textboxRef?.focus();
      textboxRef?.select();
      openOnFocusFlagBlock.current = false;
    }
  }, [textboxRef, triggerChange, openOnFocus]);
  const onSelectListClose = useCallback(() => {
    setOpen(false);
    setMatchingText(selectedValue, true);
  }, [selectedValue, setMatchingText]);
  function handleTextboxClick(event) {
    isMouseDownReported.current = false;
    if (onClick) {
      onClick(event);
    }
  }
  function handleDropdownIconClick(event) {
    isMouseDownReported.current = false;
    if (onClick) {
      onClick(event);
    }
    setOpen(isAlreadyOpen => {
      return !isAlreadyOpen;
    });
  }
  function handleTextboxFocus(event) {
    const triggerFocus = () => onFocus?.(event);
    if (openOnFocus) {
      if (focusTimer.current) {
        clearTimeout(focusTimer.current);
      }
      if (openOnFocusFlagBlock.current) {
        return;
      }

      // we need to use a timeout here as there is a race condition when rendered in a modal
      // whereby the select list isn't visible when the select is auto focused straight away
      focusTimer.current = setTimeout(() => {
        setOpen(isAlreadyOpen => {
          if (isAlreadyOpen) {
            return true;
          }
          if (onFocus && !isInputFocused.current) {
            triggerFocus();
            isInputFocused.current = true;
          }
          if (isMouseDownReported.current && !isMouseDownOnInput.current) {
            return false;
          }
          return true;
        });
      });
    } else if (onFocus && !isInputFocused.current) {
      triggerFocus();
      isInputFocused.current = true;
    }
  }
  function handleTextboxBlur(event) {
    isMouseDownOnInput.current = false;
    if (isMouseDownReported.current) {
      return;
    }
    isInputFocused.current = false;
    if (onBlur) {
      onBlur(event);
    }
  }
  function handleTextboxMouseDown(event) {
    isMouseDownReported.current = true;
    if (event.target.dataset.element === "input") {
      isMouseDownOnInput.current = true;
    }
  }
  function handleListMouseDown() {
    isMouseDownReported.current = true;
  }
  function handleOnListAction() {
    setOpen(false);
    onListAction?.();
  }
  const assignInput = useCallback(element => {
    setTextboxRef(element);
    if (!ref) {
      return;
    }
    if (typeof ref === "function") {
      ref(element);
    } else {
      ref.current = element;
    }
  }, [ref]);
  function getTextboxProps() {
    return {
      id: inputId.current,
      name,
      label,
      disabled,
      readOnly,
      ref: assignInput,
      selectedValue,
      formattedValue: textValue,
      onClick: handleTextboxClick,
      iconOnClick: handleDropdownIconClick,
      iconOnMouseDown: handleTextboxMouseDown,
      onFocus: handleTextboxFocus,
      onBlur: handleTextboxBlur,
      onKeyDown: handleTextboxKeydown,
      onChange: handleTextboxChange,
      onMouseDown: handleTextboxMouseDown,
      tooltipPosition,
      required,
      isOptional,
      ...filterOutStyledSystemSpacingProps(textboxProps)
    };
  }
  const selectListProps = {
    ref: listboxRef,
    id: selectListId.current,
    labelId,
    anchorElement: textboxRef?.parentElement || undefined,
    onSelect: onSelectOption,
    onSelectListClose,
    onMouseDown: handleListMouseDown,
    filterText: filterText.trim(),
    highlightedValue,
    noResultsMessage,
    listActionButton,
    listMaxHeight,
    onListAction: handleOnListAction,
    isLoading,
    onListScrollBottom,
    tableHeader,
    multiColumn,
    loaderDataRole: "filterable-select-list-loader",
    listPlacement,
    flipEnabled,
    isOpen,
    enableVirtualScroll,
    virtualScrollOverscan
  };
  const selectList = disableDefaultFiltering ? /*#__PURE__*/React.createElement(SelectList, selectListProps, children) : /*#__PURE__*/React.createElement(FilterableSelectList, selectListProps, children);
  const marginProps = useFormSpacing(textboxProps);
  return /*#__PURE__*/React.createElement(StyledSelect, _extends({
    hasTextCursor: true,
    readOnly: readOnly,
    disabled: disabled,
    "data-component": dataComponent,
    "data-role": dataRole,
    "data-element": dataElement,
    isOpen: isOpen
  }, marginProps), /*#__PURE__*/React.createElement("div", {
    ref: containerRef
  }, /*#__PURE__*/React.createElement(SelectTextbox, _extends({
    activeDescendantId: activeDescendantId,
    ariaLabel: ariaLabel,
    ariaLabelledby: ariaLabelledby,
    labelId: label ? labelId : undefined,
    "aria-controls": selectListId.current,
    isOpen: isOpen,
    hasTextCursor: true,
    textboxRef: textboxRef
  }, getTextboxProps()))), selectList);
});
if (process.env.NODE_ENV !== "production") {
  FilterableSelect.propTypes = {
    "about": PropTypes.string,
    "accept": PropTypes.string,
    "accessibilityLabelId": PropTypes.string,
    "accessKey": PropTypes.string,
    "adaptiveLabelBreakpoint": PropTypes.number,
    "align": PropTypes.oneOf(["left", "right"]),
    "alt": PropTypes.string,
    "aria-activedescendant": PropTypes.string,
    "aria-atomic": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-autocomplete": PropTypes.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-checked": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-colcount": PropTypes.number,
    "aria-colindex": PropTypes.number,
    "aria-colspan": PropTypes.number,
    "aria-controls": PropTypes.string,
    "aria-current": PropTypes.oneOfType([PropTypes.oneOf(["date", "false", "location", "page", "step", "time", "true"]), PropTypes.bool]),
    "aria-describedby": PropTypes.string,
    "aria-details": PropTypes.string,
    "aria-disabled": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-dropeffect": PropTypes.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": PropTypes.string,
    "aria-expanded": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-flowto": PropTypes.string,
    "aria-grabbed": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-haspopup": PropTypes.oneOfType([PropTypes.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), PropTypes.bool]),
    "aria-hidden": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-invalid": PropTypes.oneOfType([PropTypes.oneOf(["false", "grammar", "spelling", "true"]), PropTypes.bool]),
    "aria-keyshortcuts": PropTypes.string,
    "aria-label": PropTypes.string,
    "aria-labelledby": PropTypes.string,
    "aria-level": PropTypes.number,
    "aria-live": PropTypes.oneOf(["assertive", "off", "polite"]),
    "aria-modal": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiline": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-multiselectable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-orientation": PropTypes.oneOf(["horizontal", "vertical"]),
    "aria-owns": PropTypes.string,
    "aria-placeholder": PropTypes.string,
    "aria-posinset": PropTypes.number,
    "aria-pressed": PropTypes.oneOfType([PropTypes.oneOf(["false", "mixed", "true"]), PropTypes.bool]),
    "aria-readonly": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-relevant": PropTypes.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-roledescription": PropTypes.string,
    "aria-rowcount": PropTypes.number,
    "aria-rowindex": PropTypes.number,
    "aria-rowspan": PropTypes.number,
    "aria-selected": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "aria-setsize": PropTypes.number,
    "aria-sort": PropTypes.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": PropTypes.number,
    "aria-valuemin": PropTypes.number,
    "aria-valuenow": PropTypes.number,
    "aria-valuetext": PropTypes.string,
    "ariaDescribedBy": PropTypes.string,
    "ariaLabel": PropTypes.string,
    "ariaLabelledby": PropTypes.string,
    "as": PropTypes.elementType,
    "autoCapitalize": PropTypes.string,
    "autoComplete": PropTypes.string,
    "autoCorrect": PropTypes.string,
    "autoFocus": PropTypes.bool,
    "autoSave": PropTypes.string,
    "capture": PropTypes.oneOfType([PropTypes.oneOf(["environment", "user"]), PropTypes.bool]),
    "checked": PropTypes.bool,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "color": PropTypes.string,
    "content": PropTypes.string,
    "contentEditable": PropTypes.oneOfType([PropTypes.oneOf(["false", "inherit", "true"]), PropTypes.bool]),
    "contextMenu": PropTypes.string,
    "dangerouslySetInnerHTML": PropTypes.shape({
      "__html": PropTypes.oneOfType([PropTypes.object, PropTypes.string]).isRequired
    }),
    "data-component": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "datatype": PropTypes.string,
    "defaultChecked": PropTypes.bool,
    "defaultValue": PropTypes.oneOfType([PropTypes.object, PropTypes.string]),
    "deferTimeout": PropTypes.number,
    "dir": PropTypes.string,
    "disabled": PropTypes.bool,
    "disableDefaultFiltering": PropTypes.bool,
    "draggable": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "enableVirtualScroll": PropTypes.bool,
    "enterKeyHint": PropTypes.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "fieldHelp": PropTypes.node,
    "flipEnabled": PropTypes.bool,
    "form": PropTypes.string,
    "formAction": PropTypes.string,
    "formattedValue": PropTypes.string,
    "formEncType": PropTypes.string,
    "formMethod": PropTypes.string,
    "formNoValidate": PropTypes.bool,
    "formTarget": PropTypes.string,
    "height": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "helpAriaLabel": PropTypes.string,
    "hidden": PropTypes.bool,
    "iconOnClick": PropTypes.func,
    "iconOnMouseDown": PropTypes.func,
    "iconTabIndex": PropTypes.number,
    "id": PropTypes.string,
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "inlist": PropTypes.any,
    "inputHint": PropTypes.string,
    "inputIcon": PropTypes.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "marker", "message", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]),
    "inputMode": PropTypes.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputWidth": PropTypes.number,
    "is": PropTypes.string,
    "isLoading": PropTypes.bool,
    "isOptional": PropTypes.bool,
    "itemID": PropTypes.string,
    "itemProp": PropTypes.string,
    "itemRef": PropTypes.string,
    "itemScope": PropTypes.bool,
    "itemType": PropTypes.string,
    "label": PropTypes.string,
    "labelAlign": PropTypes.oneOf(["left", "right"]),
    "labelHelp": PropTypes.node,
    "labelId": PropTypes.string,
    "labelInline": PropTypes.bool,
    "labelSpacing": PropTypes.oneOf([1, 2]),
    "labelWidth": PropTypes.number,
    "lang": PropTypes.string,
    "leftChildren": PropTypes.node,
    "list": PropTypes.string,
    "listActionButton": PropTypes.oneOfType([PropTypes.element, PropTypes.bool]),
    "listMaxHeight": PropTypes.number,
    "listPlacement": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "max": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "maxLength": PropTypes.number,
    "maxWidth": PropTypes.string,
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "min": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "minLength": PropTypes.number,
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "multiColumn": PropTypes.bool,
    "multiple": PropTypes.bool,
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string,
    "nonce": PropTypes.string,
    "noResultsMessage": PropTypes.string,
    "onAbort": PropTypes.func,
    "onAbortCapture": PropTypes.func,
    "onAnimationEnd": PropTypes.func,
    "onAnimationEndCapture": PropTypes.func,
    "onAnimationIteration": PropTypes.func,
    "onAnimationIterationCapture": PropTypes.func,
    "onAnimationStart": PropTypes.func,
    "onAnimationStartCapture": PropTypes.func,
    "onAuxClick": PropTypes.func,
    "onAuxClickCapture": PropTypes.func,
    "onBeforeInput": PropTypes.func,
    "onBeforeInputCapture": PropTypes.func,
    "onBlur": PropTypes.func,
    "onBlurCapture": PropTypes.func,
    "onCanPlay": PropTypes.func,
    "onCanPlayCapture": PropTypes.func,
    "onCanPlayThrough": PropTypes.func,
    "onCanPlayThroughCapture": PropTypes.func,
    "onChange": PropTypes.func,
    "onChangeCapture": PropTypes.func,
    "onChangeDeferred": PropTypes.func,
    "onClick": PropTypes.func,
    "onClickCapture": PropTypes.func,
    "onCompositionEnd": PropTypes.func,
    "onCompositionEndCapture": PropTypes.func,
    "onCompositionStart": PropTypes.func,
    "onCompositionStartCapture": PropTypes.func,
    "onCompositionUpdate": PropTypes.func,
    "onCompositionUpdateCapture": PropTypes.func,
    "onContextMenu": PropTypes.func,
    "onContextMenuCapture": PropTypes.func,
    "onCopy": PropTypes.func,
    "onCopyCapture": PropTypes.func,
    "onCut": PropTypes.func,
    "onCutCapture": PropTypes.func,
    "onDoubleClick": PropTypes.func,
    "onDoubleClickCapture": PropTypes.func,
    "onDrag": PropTypes.func,
    "onDragCapture": PropTypes.func,
    "onDragEnd": PropTypes.func,
    "onDragEndCapture": PropTypes.func,
    "onDragEnter": PropTypes.func,
    "onDragEnterCapture": PropTypes.func,
    "onDragExit": PropTypes.func,
    "onDragExitCapture": PropTypes.func,
    "onDragLeave": PropTypes.func,
    "onDragLeaveCapture": PropTypes.func,
    "onDragOver": PropTypes.func,
    "onDragOverCapture": PropTypes.func,
    "onDragStart": PropTypes.func,
    "onDragStartCapture": PropTypes.func,
    "onDrop": PropTypes.func,
    "onDropCapture": PropTypes.func,
    "onDurationChange": PropTypes.func,
    "onDurationChangeCapture": PropTypes.func,
    "onEmptied": PropTypes.func,
    "onEmptiedCapture": PropTypes.func,
    "onEncrypted": PropTypes.func,
    "onEncryptedCapture": PropTypes.func,
    "onEnded": PropTypes.func,
    "onEndedCapture": PropTypes.func,
    "onError": PropTypes.func,
    "onErrorCapture": PropTypes.func,
    "onFilterChange": PropTypes.func,
    "onFocus": PropTypes.func,
    "onFocusCapture": PropTypes.func,
    "onGotPointerCapture": PropTypes.func,
    "onGotPointerCaptureCapture": PropTypes.func,
    "onInput": PropTypes.func,
    "onInputCapture": PropTypes.func,
    "onInvalid": PropTypes.func,
    "onInvalidCapture": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "onKeyDownCapture": PropTypes.func,
    "onKeyPress": PropTypes.func,
    "onKeyPressCapture": PropTypes.func,
    "onKeyUp": PropTypes.func,
    "onKeyUpCapture": PropTypes.func,
    "onListAction": PropTypes.func,
    "onListScrollBottom": PropTypes.func,
    "onLoad": PropTypes.func,
    "onLoadCapture": PropTypes.func,
    "onLoadedData": PropTypes.func,
    "onLoadedDataCapture": PropTypes.func,
    "onLoadedMetadata": PropTypes.func,
    "onLoadedMetadataCapture": PropTypes.func,
    "onLoadStart": PropTypes.func,
    "onLoadStartCapture": PropTypes.func,
    "onLostPointerCapture": PropTypes.func,
    "onLostPointerCaptureCapture": PropTypes.func,
    "onMouseDown": PropTypes.func,
    "onMouseDownCapture": PropTypes.func,
    "onMouseEnter": PropTypes.func,
    "onMouseLeave": PropTypes.func,
    "onMouseMove": PropTypes.func,
    "onMouseMoveCapture": PropTypes.func,
    "onMouseOut": PropTypes.func,
    "onMouseOutCapture": PropTypes.func,
    "onMouseOver": PropTypes.func,
    "onMouseOverCapture": PropTypes.func,
    "onMouseUp": PropTypes.func,
    "onMouseUpCapture": PropTypes.func,
    "onOpen": PropTypes.func,
    "onPaste": PropTypes.func,
    "onPasteCapture": PropTypes.func,
    "onPause": PropTypes.func,
    "onPauseCapture": PropTypes.func,
    "onPlay": PropTypes.func,
    "onPlayCapture": PropTypes.func,
    "onPlaying": PropTypes.func,
    "onPlayingCapture": PropTypes.func,
    "onPointerCancel": PropTypes.func,
    "onPointerCancelCapture": PropTypes.func,
    "onPointerDown": PropTypes.func,
    "onPointerDownCapture": PropTypes.func,
    "onPointerEnter": PropTypes.func,
    "onPointerEnterCapture": PropTypes.func,
    "onPointerLeave": PropTypes.func,
    "onPointerLeaveCapture": PropTypes.func,
    "onPointerMove": PropTypes.func,
    "onPointerMoveCapture": PropTypes.func,
    "onPointerOut": PropTypes.func,
    "onPointerOutCapture": PropTypes.func,
    "onPointerOver": PropTypes.func,
    "onPointerOverCapture": PropTypes.func,
    "onPointerUp": PropTypes.func,
    "onPointerUpCapture": PropTypes.func,
    "onProgress": PropTypes.func,
    "onProgressCapture": PropTypes.func,
    "onRateChange": PropTypes.func,
    "onRateChangeCapture": PropTypes.func,
    "onReset": PropTypes.func,
    "onResetCapture": PropTypes.func,
    "onScroll": PropTypes.func,
    "onScrollCapture": PropTypes.func,
    "onSeeked": PropTypes.func,
    "onSeekedCapture": PropTypes.func,
    "onSeeking": PropTypes.func,
    "onSeekingCapture": PropTypes.func,
    "onSelect": PropTypes.func,
    "onSelectCapture": PropTypes.func,
    "onStalled": PropTypes.func,
    "onStalledCapture": PropTypes.func,
    "onSubmit": PropTypes.func,
    "onSubmitCapture": PropTypes.func,
    "onSuspend": PropTypes.func,
    "onSuspendCapture": PropTypes.func,
    "onTimeUpdate": PropTypes.func,
    "onTimeUpdateCapture": PropTypes.func,
    "onTouchCancel": PropTypes.func,
    "onTouchCancelCapture": PropTypes.func,
    "onTouchEnd": PropTypes.func,
    "onTouchEndCapture": PropTypes.func,
    "onTouchMove": PropTypes.func,
    "onTouchMoveCapture": PropTypes.func,
    "onTouchStart": PropTypes.func,
    "onTouchStartCapture": PropTypes.func,
    "onTransitionEnd": PropTypes.func,
    "onTransitionEndCapture": PropTypes.func,
    "onVolumeChange": PropTypes.func,
    "onVolumeChangeCapture": PropTypes.func,
    "onWaiting": PropTypes.func,
    "onWaitingCapture": PropTypes.func,
    "onWheel": PropTypes.func,
    "onWheelCapture": PropTypes.func,
    "openOnFocus": PropTypes.bool,
    "pattern": PropTypes.string,
    "placeholder": PropTypes.string,
    "prefix": PropTypes.string,
    "property": PropTypes.string,
    "radioGroup": PropTypes.string,
    "readOnly": PropTypes.bool,
    "rel": PropTypes.string,
    "required": PropTypes.bool,
    "resource": PropTypes.string,
    "results": PropTypes.number,
    "rev": PropTypes.string,
    "reverse": PropTypes.bool,
    "role": PropTypes.oneOfType([PropTypes.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), PropTypes.shape({
      "__@iterator": PropTypes.func.isRequired,
      "anchor": PropTypes.func.isRequired,
      "at": PropTypes.func.isRequired,
      "big": PropTypes.func.isRequired,
      "blink": PropTypes.func.isRequired,
      "bold": PropTypes.func.isRequired,
      "charAt": PropTypes.func.isRequired,
      "charCodeAt": PropTypes.func.isRequired,
      "codePointAt": PropTypes.func.isRequired,
      "concat": PropTypes.func.isRequired,
      "endsWith": PropTypes.func.isRequired,
      "fixed": PropTypes.func.isRequired,
      "fontcolor": PropTypes.func.isRequired,
      "fontsize": PropTypes.func.isRequired,
      "includes": PropTypes.func.isRequired,
      "indexOf": PropTypes.func.isRequired,
      "italics": PropTypes.func.isRequired,
      "lastIndexOf": PropTypes.func.isRequired,
      "length": PropTypes.number.isRequired,
      "link": PropTypes.func.isRequired,
      "localeCompare": PropTypes.func.isRequired,
      "match": PropTypes.func.isRequired,
      "matchAll": PropTypes.func.isRequired,
      "normalize": PropTypes.func.isRequired,
      "padEnd": PropTypes.func.isRequired,
      "padStart": PropTypes.func.isRequired,
      "repeat": PropTypes.func.isRequired,
      "replace": PropTypes.func.isRequired,
      "search": PropTypes.func.isRequired,
      "slice": PropTypes.func.isRequired,
      "small": PropTypes.func.isRequired,
      "split": PropTypes.func.isRequired,
      "startsWith": PropTypes.func.isRequired,
      "strike": PropTypes.func.isRequired,
      "sub": PropTypes.func.isRequired,
      "substr": PropTypes.func.isRequired,
      "substring": PropTypes.func.isRequired,
      "sup": PropTypes.func.isRequired,
      "toLocaleLowerCase": PropTypes.func.isRequired,
      "toLocaleUpperCase": PropTypes.func.isRequired,
      "toLowerCase": PropTypes.func.isRequired,
      "toString": PropTypes.func.isRequired,
      "toUpperCase": PropTypes.func.isRequired,
      "trim": PropTypes.func.isRequired,
      "trimEnd": PropTypes.func.isRequired,
      "trimLeft": PropTypes.func.isRequired,
      "trimRight": PropTypes.func.isRequired,
      "trimStart": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    })]),
    "security": PropTypes.string,
    "size": PropTypes.oneOf(["large", "medium", "small"]),
    "slot": PropTypes.string,
    "spellCheck": PropTypes.oneOfType([PropTypes.oneOf(["false", "true"]), PropTypes.bool]),
    "src": PropTypes.string,
    "step": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "style": PropTypes.object,
    "suppressContentEditableWarning": PropTypes.bool,
    "suppressHydrationWarning": PropTypes.bool,
    "tabIndex": PropTypes.number,
    "tableHeader": PropTypes.node,
    "title": PropTypes.string,
    "tooltipPosition": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "translate": PropTypes.oneOf(["no", "yes"]),
    "typeof": PropTypes.string,
    "unselectable": PropTypes.oneOf(["off", "on"]),
    "validationIconId": PropTypes.string,
    "validationOnLabel": PropTypes.bool,
    "value": PropTypes.oneOfType([PropTypes.object, PropTypes.string]),
    "virtualScrollOverscan": PropTypes.number,
    "vocab": PropTypes.string,
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "width": PropTypes.oneOfType([PropTypes.number, PropTypes.string])
  };
}
export { FilterableSelect };
export default FilterableSelect;