import React from "react";
import PropTypes from "prop-types";
import { StyledSelectText, StyledSelectTextChildrenWrapper } from "./select-text.style";
const SelectText = ({
  disabled,
  formattedValue = "",
  onClick,
  onMouseDown,
  placeholder,
  readOnly,
  transparent,
  size = "medium"
}) => {
  const hasPlaceholder = !disabled && !readOnly && !formattedValue;
  return /*#__PURE__*/React.createElement(StyledSelectText, {
    "aria-hidden": true,
    "data-element": "select-text",
    disabled: disabled,
    hasPlaceholder: hasPlaceholder,
    onClick: onClick,
    onMouseDown: onMouseDown,
    readOnly: readOnly,
    transparent: transparent,
    size: size
  }, /*#__PURE__*/React.createElement(StyledSelectTextChildrenWrapper, null, hasPlaceholder ? placeholder : formattedValue));
};
export default SelectText;