function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useRef, useImperativeHandle } from "react";
import PropTypes from "prop-types";
import invariant from "invariant";
import { filterStyledSystemMarginProps } from "../../style/utils";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import StyledSearch from "./search.style";
import StyledSearchButton from "./search-button.style";
import Icon from "../icon";
import Textbox from "../textbox";
import Button from "../button";
import Logger from "../../__internal__/utils/logger";
import useLocale from "../../hooks/__internal__/useLocale";
let deprecateUncontrolledWarnTriggered = false;
const Search = /*#__PURE__*/React.forwardRef(({
  defaultValue,
  onChange,
  onClick,
  onFocus,
  onBlur,
  onKeyDown,
  value,
  id,
  name,
  searchWidth,
  maxWidth,
  searchButton,
  searchButtonAriaLabel = "search button",
  placeholder,
  variant = "default",
  "aria-label": ariaLabel = "search",
  tabIndex,
  error,
  warning,
  info,
  tooltipPosition,
  ...rest
}, ref) => {
  const isControlled = value !== undefined;
  const initialValue = isControlled ? value : defaultValue;
  const locale = useLocale();
  const searchRef = useRef(null);
  const inputRef = useRef(null);
  useImperativeHandle(ref, () => ({
    focus() {
      inputRef.current?.focus();
    }
  }), []);
  if (!deprecateUncontrolledWarnTriggered && !isControlled) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Search` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  !(typeof initialValue === "string") ? process.env.NODE_ENV !== "production" ? invariant(false, "This component has no initial value") : invariant(false) : void 0;
  const [searchValue, setSearchValue] = useState(initialValue);
  const [isFocused, setIsFocused] = useState(false);
  const isSearchValueEmpty = !isControlled ? searchValue.length === 0 : value.length === 0;
  let buttonProps = {};
  const handleChange = event => {
    if (onChange) {
      onChange(event);
    }
    if (!isControlled) {
      setSearchValue(event.target.value);
    }
  };
  const handleFocus = event => {
    setIsFocused(true);
    if (onFocus) {
      onFocus(event);
    }
  };
  if (searchButton && onClick) {
    buttonProps = {
      onClick: () => {
        onClick({
          target: {
            name,
            id,
            value: !isControlled ? searchValue : value
          }
        });
      }
    };
  }
  const handleIconClick = () => {
    setSearchValue("");
    if (onChange) {
      onChange({
        target: {
          ...(name && {
            name
          }),
          ...(id && {
            id
          }),
          value: ""
        }
      });
    }
    inputRef.current?.focus();
  };
  const handleMouseDown = event => {
    event.preventDefault();
  };
  const handleBlur = event => {
    setIsFocused(false);

    /* istanbul ignore else */
    if (onBlur) {
      onBlur(event);
    }
  };
  const handleKeyDown = event => {
    if (event.key.length === 1) {
      event.stopPropagation();
    }
    if (onKeyDown) {
      onKeyDown(event);
    }
  };
  const searchButtonText = typeof searchButton === "string" ? searchButton : locale.search.searchButtonText();
  const searchHasValue = !isControlled ? !!searchValue?.length : !!value?.length;
  return /*#__PURE__*/React.createElement(StyledSearch, _extends({
    ref: searchRef,
    isFocused: isFocused,
    searchWidth: searchWidth,
    maxWidth: maxWidth,
    searchHasValue: searchHasValue,
    showSearchButton: !!searchButton,
    variant: variant,
    mb: 0
  }, filterStyledSystemMarginProps(rest), tagComponent("search", rest), {
    id: id,
    name: name
  }, rest), /*#__PURE__*/React.createElement(Textbox, {
    placeholder: placeholder,
    value: !isControlled ? searchValue : value,
    inputIcon: !isSearchValueEmpty ? "cross" : undefined,
    iconTabIndex: !isSearchValueEmpty ? 0 : -1,
    iconOnClick: handleIconClick,
    iconOnMouseDown: handleMouseDown,
    "aria-label": ariaLabel,
    onFocus: handleFocus,
    onBlur: handleBlur,
    onChange: handleChange,
    onKeyDown: handleKeyDown,
    ref: inputRef,
    tabIndex: tabIndex,
    error: error,
    warning: warning,
    info: info,
    leftChildren: !searchButton ? /*#__PURE__*/React.createElement(Icon, {
      type: "search",
      ml: 1
    }) : undefined,
    tooltipPosition: tooltipPosition
  }), searchButton && /*#__PURE__*/React.createElement(StyledSearchButton, null, /*#__PURE__*/React.createElement(Button, _extends({
    "aria-label": searchButtonAriaLabel,
    size: "medium",
    px: 2,
    buttonType: "primary",
    iconPosition: "before",
    iconType: "search",
    className: "search-button"
  }, buttonProps), searchButtonText)));
});
if (process.env.NODE_ENV !== "production") {
  Search.propTypes = {
    "aria-label": PropTypes.string,
    "children": PropTypes.node,
    "defaultValue": PropTypes.string,
    "error": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "id": PropTypes.string,
    "info": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "maxWidth": PropTypes.string,
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "name": PropTypes.string,
    "onBlur": PropTypes.func,
    "onChange": PropTypes.func,
    "onClick": PropTypes.func,
    "onFocus": PropTypes.func,
    "onKeyDown": PropTypes.func,
    "placeholder": PropTypes.string,
    "searchButton": PropTypes.oneOfType([PropTypes.string, PropTypes.bool]),
    "searchButtonAriaLabel": PropTypes.string,
    "searchWidth": PropTypes.string,
    "tabIndex": PropTypes.number,
    "tooltipPosition": PropTypes.oneOf(["bottom", "left", "right", "top"]),
    "value": PropTypes.string,
    "variant": PropTypes.oneOf(["dark", "default"]),
    "warning": PropTypes.oneOfType([PropTypes.string, PropTypes.bool])
  };
}
export { Search };
Search.displayName = "Search";
export default Search;