import React from "react";
import { MarginProps } from "styled-system";
import { CommonCheckableInputProps } from "../../__internal__/checkable-input";
interface InternalRadioButtonProps {
    inline?: boolean;
}
export interface RadioButtonProps extends Omit<CommonCheckableInputProps, "required" | "IsOptional">, MarginProps {
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-component"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** Accepts a callback function which is triggered on click event */
    onClick?: (ev: React.MouseEvent<HTMLInputElement>) => void;
    /** the value of the Radio Button, passed on form submit */
    value: string;
    /** Overrides the default tooltip position */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** Aria label for rendered help component */
    helpAriaLabel?: string;
}
export declare const RadioButton: React.ForwardRefExoticComponent<RadioButtonProps & InternalRadioButtonProps & React.RefAttributes<HTMLInputElement>>;
declare const _default: React.MemoExoticComponent<React.ForwardRefExoticComponent<RadioButtonProps & InternalRadioButtonProps & React.RefAttributes<HTMLInputElement>>>;
export default _default;
