function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useContext } from "react";
import PropTypes from "prop-types";
import tagComponent from "../../../__internal__/utils/helpers/tags/tags";
import Fieldset from "../../../__internal__/fieldset";
import RadioButtonGroupStyle, { StyledHintText } from "../radio-button-group/radio-button-group.style";
import RadioButtonMapper from "../../../__internal__/radio-button-mapper/radio-button-mapper.component";
import useIsAboveBreakpoint from "../../../hooks/__internal__/useIsAboveBreakpoint";
import { filterStyledSystemMarginProps } from "../../../style/utils";
import { TooltipProvider } from "../../../__internal__/tooltip-provider";
import Logger from "../../../__internal__/utils/logger";
import { NewValidationContext } from "../../carbon-provider/carbon-provider.component";
import ValidationMessage from "../../../__internal__/validation-message/validation-message.component";
import Box from "../../box";
import { ErrorBorder } from "../../textbox/textbox.style";
let deprecateUncontrolledWarnTriggered = false;
export const RadioButtonGroup = props => {
  const {
    children,
    name,
    legend,
    legendHelp,
    error,
    warning,
    info,
    onBlur,
    onChange,
    value,
    inline = false,
    legendInline = false,
    legendWidth,
    legendAlign,
    legendSpacing,
    labelSpacing = 1,
    adaptiveLegendBreakpoint,
    adaptiveSpacingBreakpoint,
    required,
    isOptional,
    tooltipPosition
  } = props;
  const {
    validationRedesignOptIn
  } = useContext(NewValidationContext);
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    Logger.deprecate("Uncontrolled behaviour in `Radio Button` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  const marginProps = filterStyledSystemMarginProps(props);
  const isAboveLegendBreakpoint = useIsAboveBreakpoint(adaptiveLegendBreakpoint);
  const isAboveSpacingBreakpoint = useIsAboveBreakpoint(adaptiveSpacingBreakpoint);
  let inlineLegend = legendInline;
  if (adaptiveLegendBreakpoint) {
    inlineLegend = !!isAboveLegendBreakpoint;
  }
  let marginLeft = marginProps.ml;
  if (adaptiveSpacingBreakpoint && !isAboveSpacingBreakpoint) {
    marginLeft = undefined;
  }
  return /*#__PURE__*/React.createElement(React.Fragment, null, validationRedesignOptIn ? /*#__PURE__*/React.createElement(Fieldset, _extends({
    legend: legend,
    error: error,
    warning: warning,
    info: info,
    inline: inlineLegend,
    legendWidth: legendWidth,
    legendAlign: legendAlign,
    legendSpacing: legendSpacing,
    isRequired: required,
    isOptional: isOptional
  }, tagComponent("radiogroup", props), marginProps, {
    ml: marginLeft,
    blockGroupBehaviour: !(error || warning)
  }), legendHelp && /*#__PURE__*/React.createElement(StyledHintText, null, legendHelp), /*#__PURE__*/React.createElement(Box, {
    position: "relative"
  }, /*#__PURE__*/React.createElement(ValidationMessage, {
    error: error,
    warning: warning
  }), (error || warning) && /*#__PURE__*/React.createElement(ErrorBorder, {
    inline: inline,
    warning: !!(!error && warning)
  }), /*#__PURE__*/React.createElement(RadioButtonGroupStyle, {
    "data-component": "radio-button-group",
    role: "radiogroup",
    inline: inline,
    legendInline: inlineLegend
  }, /*#__PURE__*/React.createElement(RadioButtonMapper, {
    name: name,
    onBlur: onBlur,
    onChange: onChange,
    value: value
  }, React.Children.map(children, child => {
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return child;
    }
    return /*#__PURE__*/React.cloneElement(child, {
      inline,
      labelSpacing,
      error: !!error,
      warning: !!warning,
      info: !!info,
      required,
      ...child.props
    });
  }))))) : /*#__PURE__*/React.createElement(TooltipProvider, {
    tooltipPosition: tooltipPosition
  }, /*#__PURE__*/React.createElement(Fieldset, _extends({
    legend: legend,
    error: error,
    warning: warning,
    info: info,
    inline: inlineLegend,
    legendWidth: legendWidth,
    legendAlign: legendAlign,
    legendSpacing: legendSpacing,
    isRequired: required,
    isOptional: isOptional
  }, tagComponent("radiogroup", props), marginProps, {
    ml: marginLeft,
    blockGroupBehaviour: !(error || warning || info)
  }), /*#__PURE__*/React.createElement(RadioButtonGroupStyle, {
    "data-component": "radio-button-group",
    role: "radiogroup",
    inline: inline,
    legendInline: inlineLegend
  }, /*#__PURE__*/React.createElement(RadioButtonMapper, {
    name: name,
    onBlur: onBlur,
    onChange: onChange,
    value: value
  }, React.Children.map(children, child => {
    if (! /*#__PURE__*/React.isValidElement(child)) {
      return child;
    }
    return /*#__PURE__*/React.cloneElement(child, {
      inline,
      labelSpacing,
      error: !!error,
      warning: !!warning,
      info: !!info,
      ...child.props
    });
  }))))));
};
RadioButtonGroup.displayName = "RadioButtonGroup";
export default RadioButtonGroup;