function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useLayoutEffect, useRef, useState } from "react";
import PropTypes from "prop-types";
import useLocale from "../../hooks/__internal__/useLocale";
import tagComponent from "../../__internal__/utils/helpers/tags";
import { StyledProgressBar, InnerBar, StyledValuesLabel, StyledProgressTracker, StyledValue, StyledDescription } from "./progress-tracker.style";
import useResizeObserver from "../../hooks/__internal__/useResizeObserver";
const ProgressTracker = ({
  "aria-label": ariaLabel = "progress tracker",
  "aria-describedby": ariaDescribedBy,
  "aria-valuenow": ariaValueNow,
  "aria-valuemin": ariaValueMin = 0,
  "aria-valuemax": ariaValueMax = 100,
  "aria-valuetext": ariaValueText,
  size = "medium",
  length = "256px",
  error = false,
  progress = 0,
  description,
  showDefaultLabels = false,
  currentProgressLabel,
  customValuePreposition,
  maxProgressLabel,
  labelsPosition = "top",
  labelWidth,
  ...rest
}) => {
  const l = useLocale();
  const barRef = useRef(null);
  const [barLength, setBarLength] = useState("0px");
  const prefixLabels = labelsPosition !== "bottom";
  const updateBarLength = useCallback(() => {
    setBarLength(`${barRef.current?.offsetWidth}px`);
  }, []);
  useLayoutEffect(() => {
    updateBarLength();
  }, [updateBarLength]);
  useResizeObserver(barRef, () => {
    updateBarLength();
  });
  const renderValueLabels = () => {
    if (!showDefaultLabels && !currentProgressLabel) {
      return null;
    }
    const label = (value, defaultValue) => {
      if (value) {
        return value;
      }
      return showDefaultLabels ? defaultValue : undefined;
    };
    const displayedCurrentProgressLabel = label(currentProgressLabel, `${progress}%`);
    const displayedMaxProgressLabel = label(maxProgressLabel, "100%");
    return /*#__PURE__*/React.createElement(StyledValuesLabel, {
      labelsPosition: labelsPosition,
      size: size,
      labelWidth: labelWidth
    }, displayedCurrentProgressLabel && /*#__PURE__*/React.createElement(StyledValue, {
      "data-element": "current-progress-label"
    }, displayedCurrentProgressLabel), displayedMaxProgressLabel && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("span", {
      "data-element": "custom-preposition"
    }, customValuePreposition || l.progressTracker.of()), /*#__PURE__*/React.createElement(StyledValue, {
      "data-element": "max-progress-label"
    }, displayedMaxProgressLabel)), description && /*#__PURE__*/React.createElement(StyledDescription, {
      "data-element": "progress-tracker-description"
    }, description));
  };
  const defaultValueNow = ariaValueMin + (ariaValueMax - ariaValueMin) * progress / 100;
  return /*#__PURE__*/React.createElement(StyledProgressTracker, _extends({
    length: length
  }, rest, tagComponent("progress-bar", rest), {
    role: "progressbar",
    "aria-label": ariaLabel,
    "aria-describedby": ariaDescribedBy,
    "aria-valuenow": ariaValueNow === undefined ? defaultValueNow : ariaValueNow,
    "aria-valuemin": ariaValueMin,
    "aria-valuemax": ariaValueMax,
    "aria-valuetext": ariaValueText,
    labelsPosition: labelsPosition
  }), prefixLabels && renderValueLabels(), /*#__PURE__*/React.createElement(StyledProgressBar, {
    size: size,
    ref: barRef,
    progress: progress,
    error: error
  }, /*#__PURE__*/React.createElement(InnerBar, {
    "data-element": "inner-bar",
    size: size,
    length: barLength,
    progress: progress,
    error: error
  })), !prefixLabels && renderValueLabels());
};
ProgressTracker.displayName = "ProgressTracker";
export default ProgressTracker;