function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { ProfileStyle, ProfileNameStyle, ProfileDetailsStyle, ProfileAvatarStyle, ProfileEmailStyle, ProfileTextStyle } from "./profile.style";
import { filterStyledSystemMarginProps } from "../../style/utils";
function acronymize(str) {
  if (!str) return "";
  const matches = str.match(/\b\w/g);
  if (!matches) return "";
  return matches.join("");
}
let useOfNoNameWarnTriggered = false;
export const Profile = ({
  src,
  alt,
  className,
  initials,
  name,
  size,
  email,
  text,
  darkBackground,
  ...props
}) => {
  const getInitials = () => {
    if (initials) return initials;
    return acronymize(name).slice(0, 3).toUpperCase();
  };
  const commonAvatarProps = {
    darkBackground,
    alt,
    name,
    initials: getInitials(),
    size
  };
  const avatar = () => {
    if (src) {
      return /*#__PURE__*/React.createElement(ProfileAvatarStyle, _extends({
        src: src,
        "data-element": "user-image"
      }, commonAvatarProps));
    }
    return /*#__PURE__*/React.createElement(ProfileAvatarStyle, _extends({
      gravatar: email
    }, commonAvatarProps));
  };
  if (!useOfNoNameWarnTriggered && !name && (email || text)) {
    useOfNoNameWarnTriggered = true;
    console.warn("[WARNING] The `email` or `text` prop should not be used without the `name` prop in `Profile`." + " Please use the `name` prop as well as `email` or `text`.");
  }
  const children = () => {
    if (name) return /*#__PURE__*/React.createElement(ProfileDetailsStyle, {
      size: size,
      hasSrc: !!src,
      "data-element": "details"
    }, /*#__PURE__*/React.createElement(ProfileNameStyle, {
      size: size,
      "data-element": "name"
    }, name), /*#__PURE__*/React.createElement(ProfileEmailStyle, {
      href: `mailto: ${email}`,
      size: size,
      darkBackground: darkBackground,
      "data-element": "email"
    }, email), /*#__PURE__*/React.createElement(ProfileTextStyle, {
      size: size,
      "data-element": "text"
    }, text));
    return null;
  };
  return /*#__PURE__*/React.createElement(ProfileStyle, _extends({
    className: className,
    hasSrc: !!src,
    darkBackground: darkBackground
  }, tagComponent("profile", props), filterStyledSystemMarginProps(props)), avatar(), children());
};
export default Profile;