import React from "react";
import { MarginProps } from "styled-system";
import { ProfileSize } from "./profile.config";
export interface ProfileProps extends MarginProps {
    /** [Legacy] A custom class name for the component */
    className?: string;
    /** Custom source URL */
    src?: string;
    /** The `alt` HTML string. */
    alt?: string;
    /** Define the name to display. */
    name?: string;
    /** Define the email to use (will check Gravatar for image). */
    email?: string;
    /** Define read-only text to display. */
    text?: string;
    /** Define initials to display if there is no Gravatar image. */
    initials?: string;
    /** Allow to setup size for the component */
    size?: ProfileSize;
    /** Use a dark background. */
    darkBackground?: boolean;
}
export declare const Profile: ({ src, alt, className, initials, name, size, email, text, darkBackground, ...props }: ProfileProps) => React.JSX.Element;
export default Profile;
