function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React from "react";
import PropTypes from "prop-types";
import PreviewPlaceholder from "./__internal__/preview-placeholder.component";
import { StyledPreview } from "./preview.style";
import { filterStyledSystemMarginProps } from "../../style/utils";
export const Preview = ({
  children,
  loading,
  lines = 1,
  ...props
}) => {
  const marginProps = filterStyledSystemMarginProps(props);
  const hasPlaceholder = loading === undefined ? !children : loading;
  if (hasPlaceholder) {
    const placeholders = [];
    for (let i = 1; i <= lines; i++) {
      placeholders.push( /*#__PURE__*/React.createElement(PreviewPlaceholder, _extends({
        key: i,
        index: i,
        lines: lines
      }, props)));
    }
    return /*#__PURE__*/React.createElement(StyledPreview, marginProps, placeholders);
  }
  return /*#__PURE__*/React.createElement(StyledPreview, marginProps, children);
};
export default Preview;