function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useEffect, useState, useContext } from "react";
import PropTypes from "prop-types";
import MD5 from "crypto-js/md5";
import invariant from "invariant";
import Tooltip from "../tooltip";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
import { PORTRAIT_SIZE_PARAMS } from "./portrait.config";
import { StyledCustomImg, StyledIcon, StyledPortraitContainer, StyledPortraitInitials, StyledPortraitGravatar } from "./portrait.style";
import { filterStyledSystemMarginProps } from "../../style/utils";
import { NewValidationContext as RoundedCornersOptOutContext } from "../carbon-provider/carbon-provider.component";
const Portrait = ({
  alt,
  name,
  darkBackground = false,
  gravatar = "",
  iconType = "individual",
  initials,
  shape,
  size = "M",
  src,
  onClick,
  tooltipMessage,
  tooltipId,
  tooltipIsVisible,
  tooltipPosition,
  tooltipType,
  tooltipSize,
  tooltipBgColor,
  tooltipFontColor,
  ...rest
}) => {
  const [externalError, setExternalError] = useState(false);
  const {
    roundedCornersOptOut
  } = useContext(RoundedCornersOptOutContext);
  const defaultShape = roundedCornersOptOut ? "square" : "circle";
  !!(src && gravatar) ? process.env.NODE_ENV !== "production" ? invariant(false, "The `src` prop cannot be used in conjunction with the `gravatar` prop." + " Please use one or the other.") : invariant(false) : void 0;
  useEffect(() => {
    setExternalError(false);
  }, [gravatar, src]);
  const tagProps = tagComponent("portrait", rest);
  const gravatarSrc = () => {
    const {
      dimensions
    } = PORTRAIT_SIZE_PARAMS[size];
    const base = "https://www.gravatar.com/avatar/";
    const hash = MD5(gravatar.toLowerCase());
    const fallbackOption = "404"; // "Return an HTTP 404 File Not Found response"

    /** @see https://en.gravatar.com/site/implement/images/#default-image */
    return `${base}${hash}?s=${dimensions}&d=${fallbackOption}`;
  };
  const renderComponent = () => {
    let portrait = /*#__PURE__*/React.createElement(StyledIcon, {
      type: iconType,
      size: size
    });
    if (initials) {
      portrait = /*#__PURE__*/React.createElement(StyledPortraitInitials, {
        size: size,
        "data-element": "initials"
      }, initials.slice(0, 3).toUpperCase());
    }
    if (src && !externalError) {
      portrait = /*#__PURE__*/React.createElement(StyledCustomImg, {
        src: src,
        alt: alt || name || "",
        "data-element": "user-image",
        onError: () => setExternalError(true)
      });
    }
    if (gravatar && !externalError) {
      portrait = /*#__PURE__*/React.createElement(StyledPortraitGravatar, {
        src: gravatarSrc(),
        alt: alt || name || "",
        onError: () => setExternalError(true)
      });
    }
    if (tooltipMessage) {
      return /*#__PURE__*/React.createElement(Tooltip, {
        message: tooltipMessage,
        id: tooltipId,
        position: tooltipPosition,
        type: tooltipType,
        size: tooltipSize,
        isVisible: tooltipIsVisible,
        bgColor: tooltipBgColor,
        fontColor: tooltipFontColor
      }, /*#__PURE__*/React.createElement(StyledPortraitContainer, _extends({}, filterStyledSystemMarginProps(rest), {
        onClick: onClick
      }, tagProps, {
        darkBackground: darkBackground,
        size: size,
        shape: shape || defaultShape
      }), portrait));
    }
    return /*#__PURE__*/React.createElement(StyledPortraitContainer, _extends({}, filterStyledSystemMarginProps(rest), {
      onClick: onClick
    }, tagProps, {
      darkBackground: darkBackground,
      size: size,
      shape: shape || defaultShape
    }), portrait);
  };
  return renderComponent();
};
export default Portrait;