import React, { useContext, useEffect, useMemo, useState } from "react";
import ReactDOM from "react-dom";
import styled, { css } from "styled-components";
import guid from "../../__internal__/utils/helpers/guid";
import CarbonScopedTokensProvider from "../../style/design-tokens/carbon-scoped-tokens-provider/carbon-scoped-tokens-provider.component";
import StyledPortalEntrance from "./portal.style";
export const PortalContext = /*#__PURE__*/React.createContext({});
const Container = styled.div`
  ${({
  theme
}) => css`
     {
      position: relative;
      z-index: ${theme.zIndex.aboveAll};
    }
  `}
`;
export const Portal = ({
  children,
  className,
  id,
  onReposition,
  inertOptOut
}) => {
  const [portalNode, setPortalNode] = useState(null);
  const uniqueId = useMemo(() => guid(), []);
  const {
    renderInRoot
  } = useContext(PortalContext);
  useEffect(() => {
    if (onReposition) {
      onReposition();
      window.addEventListener("resize", onReposition);
    }
    return () => {
      if (onReposition) {
        window.removeEventListener("resize", onReposition);
      }
    };
  }, [onReposition]);
  useEffect(() => {
    return () => {
      portalNode?.remove();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const addClassNames = node => {
    className?.split(" ").forEach(el => {
      node?.classList.add(el);
    });
    return node;
  };
  const getPortalContainer = () => {
    const portalClassName = "carbon-portal";
    let node = portalNode;
    if (!node && id !== undefined && document.getElementById(id)) {
      node = document.getElementById(id);
      setPortalNode(node);
    } else if (!node || document.getElementsByClassName(portalClassName).length === 0) {
      node = document.createElement("div");
      node.classList.add(portalClassName);
      node.setAttribute("data-portal-exit", uniqueId);
      if (id !== undefined) {
        node.setAttribute("id", id);
      }
      if (inertOptOut) {
        node.setAttribute("data-not-inert", "true");
      }
      setPortalNode(node);
      let mainNode = document.body;
      const rootDiv = document.getElementById("root");
      if (rootDiv && renderInRoot) {
        mainNode = rootDiv;
      }
      mainNode.appendChild(node);
    }
    if (className) {
      node = addClassNames(node);
    }
    return node;
  };
  const portalContent = inertOptOut ? /*#__PURE__*/React.createElement(Container, null, children) : children;
  return /*#__PURE__*/React.createElement(StyledPortalEntrance, {
    "data-portal-entrance": uniqueId
  }, /*#__PURE__*/ReactDOM.createPortal( /*#__PURE__*/React.createElement(CarbonScopedTokensProvider, null, portalContent), getPortalContainer()));
};
export default Portal;