function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useCallback, useEffect, useRef, useState } from "react";
import PropTypes from "prop-types";
import { Transition } from "react-transition-group";
import { flip, offset } from "@floating-ui/dom";
import useMediaQuery from "../../hooks/useMediaQuery";
import { PopoverContainerWrapperStyle, PopoverContainerHeaderStyle, PopoverContainerContentStyle, PopoverContainerCloseIcon, PopoverContainerTitleStyle, PopoverContainerOpenIcon } from "./popover-container.style";
import Icon from "../icon";
import Popover from "../../__internal__/popover";
import createGuid from "../../__internal__/utils/helpers/guid";
import { filterStyledSystemPaddingProps } from "../../style/utils";
import useClickAwayListener from "../../hooks/__internal__/useClickAwayListener";
import Events from "../../__internal__/utils/helpers/events";
import FocusTrap from "../../__internal__/focus-trap";
import { ModalContext } from "../modal";
import useFocusPortalContent from "../../hooks/__internal__/useFocusPortalContent";
import tagComponent from "../../__internal__/utils/helpers/tags/tags";
export const renderOpen = ({
  tabIndex,
  onClick,
  "data-element": dataElement,
  ref,
  "aria-label": ariaLabel,
  id,
  "aria-expanded": ariaExpanded,
  "aria-haspopup": ariaHasPopup
}) => {
  return /*#__PURE__*/React.createElement(PopoverContainerOpenIcon, {
    tabIndex: tabIndex,
    onClick: onClick,
    "data-element": dataElement,
    ref: ref,
    "aria-label": ariaLabel,
    "aria-haspopup": ariaHasPopup,
    "aria-expanded": ariaExpanded,
    id: id
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "settings"
  }));
};
export const renderClose = ({
  "data-element": dataElement,
  tabIndex,
  onClick,
  ref,
  "aria-label": ariaLabel,
  closeButtonDataProps
}) => /*#__PURE__*/React.createElement(PopoverContainerCloseIcon, _extends({
  tabIndex: tabIndex,
  onClick: onClick,
  ref: ref,
  "aria-label": ariaLabel
}, tagComponent("close", {
  "data-element": dataElement,
  ...closeButtonDataProps
})), /*#__PURE__*/React.createElement(Icon, {
  type: "close"
}));
function getPopoverMiddleware(shouldCoverButton) {
  return [offset(shouldCoverButton ? ({
    rects
  }) => ({
    mainAxis: -rects.reference.height
  }) : 6), flip({
    fallbackStrategy: "initialPlacement"
  })];
}
export const PopoverContainer = ({
  children,
  title,
  position = "right",
  open,
  onOpen,
  onClose,
  renderOpenComponent = renderOpen,
  renderCloseComponent = renderClose,
  shouldCoverButton = false,
  ariaDescribedBy,
  openButtonAriaLabel,
  closeButtonAriaLabel = "close",
  containerAriaLabel,
  closeButtonDataProps,
  disableAnimation = false,
  ...rest
}) => {
  const isControlled = open !== undefined;
  const [isOpenInternal, setIsOpenInternal] = useState(false);
  const closeButtonRef = useRef(null);
  const openButtonRef = useRef(null);
  const popoverReference = useRef(null);
  const guid = useRef(createGuid());
  const popoverContentNodeRef = useRef(null);
  const popoverContainerId = title ? `PopoverContainer_${guid.current}` : undefined;
  const isOpen = isControlled ? open : isOpenInternal;
  const reduceMotion = !useMediaQuery("screen and (prefers-reduced-motion: no-preference)");
  const closePopover = useCallback(ev => {
    if (!isControlled) {
      setIsOpenInternal(false);
    }
    if (onClose) {
      onClose(ev);
    }
    if (isOpen && openButtonRef.current) {
      openButtonRef.current.focus();
    }
  }, [isControlled, isOpen, onClose]);
  const handleEscKey = useCallback(ev => {
    const eventIsFromSelectInput = Events.composedPath(ev).find(element => {
      return element instanceof HTMLElement && element.getAttribute("data-element") === "input" && element.getAttribute("aria-expanded") === "true";
    });
    if (!eventIsFromSelectInput && Events.isEscKey(ev)) {
      closePopover(ev);
    }
  }, [closePopover]);
  useEffect(() => {
    document.addEventListener("keydown", handleEscKey);
    return () => {
      document.removeEventListener("keydown", handleEscKey);
    };
  }, [handleEscKey]);
  const handleOpenButtonClick = e => {
    if (!isControlled) setIsOpenInternal(!isOpen);

    // We want the open button to close the popover if it is already open
    if (!isOpen) {
      if (onOpen) onOpen(e);
    } else if (onClose) onClose(e);
  };
  const handleCloseButtonClick = e => {
    closePopover(e);
  };
  useFocusPortalContent(shouldCoverButton ? undefined : popoverContentNodeRef, shouldCoverButton ? undefined : openButtonRef, closePopover);
  const renderOpenComponentProps = {
    tabIndex: 0,
    "aria-expanded": isOpen,
    "aria-haspopup": "dialog",
    isOpen,
    "data-element": "popover-container-open-component",
    onClick: handleOpenButtonClick,
    ref: openButtonRef,
    "aria-label": openButtonAriaLabel || title,
    id: isOpen ? undefined : popoverContainerId
  };
  const renderCloseComponentProps = {
    "data-element": "popover-container-close-component",
    tabIndex: 0,
    onClick: handleCloseButtonClick,
    ref: closeButtonRef,
    "aria-label": closeButtonAriaLabel,
    closeButtonDataProps
  };
  const handleClickAway = e => {
    if (!isControlled) setIsOpenInternal(false);
    if (onClose && isOpen) onClose(e);
  };
  const handleClick = useClickAwayListener(handleClickAway, "mousedown");
  const [isAnimationComplete, setIsAnimationComplete] = useState(false);
  const popover = state => /*#__PURE__*/React.createElement(PopoverContainerContentStyle, _extends({
    "data-element": "popover-container-content",
    role: "dialog",
    animationState: state,
    "aria-labelledby": popoverContainerId,
    "aria-label": containerAriaLabel,
    "aria-describedby": ariaDescribedBy,
    p: "16px 24px",
    ref: popoverContentNodeRef,
    tabIndex: shouldCoverButton ? -1 : undefined,
    disableAnimation: disableAnimation || reduceMotion
  }, filterStyledSystemPaddingProps(rest)), /*#__PURE__*/React.createElement(PopoverContainerHeaderStyle, null, /*#__PURE__*/React.createElement(PopoverContainerTitleStyle, {
    id: popoverContainerId,
    "data-element": "popover-container-title"
  }, title), renderCloseComponent(renderCloseComponentProps)), children);
  const childrenToRender = state => shouldCoverButton ? /*#__PURE__*/React.createElement(ModalContext.Provider, {
    value: {
      isAnimationComplete
    }
  }, /*#__PURE__*/React.createElement(FocusTrap, {
    wrapperRef: popoverContentNodeRef,
    isOpen: isOpen
  }, popover(state))) : popover(state);
  return /*#__PURE__*/React.createElement(PopoverContainerWrapperStyle, {
    "data-component": "popover-container",
    onMouseDown: handleClick
  }, /*#__PURE__*/React.createElement("div", {
    ref: popoverReference
  }, renderOpenComponent(renderOpenComponentProps)), /*#__PURE__*/React.createElement(Transition, {
    in: isOpen,
    timeout: {
      exit: 300
    },
    appear: true,
    mountOnEnter: true,
    unmountOnExit: true,
    nodeRef: popoverContentNodeRef,
    onEntered: shouldCoverButton ? /* istanbul ignore next */() => setIsAnimationComplete(true) : undefined,
    onExiting: shouldCoverButton ? /* istanbul ignore next */() => setIsAnimationComplete(false) : undefined
  }, state => isOpen && /*#__PURE__*/React.createElement(Popover, {
    reference: popoverReference,
    placement: position === "right" ? "bottom-start" : "bottom-end",
    popoverStrategy: disableAnimation || reduceMotion ? "fixed" : "absolute",
    middleware: getPopoverMiddleware(shouldCoverButton),
    childRefOverride: popoverContentNodeRef
  }, childrenToRender(state))));
};
export default PopoverContainer;