import React from "react";
import { PaddingProps } from "styled-system";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
export interface RenderOpenProps {
    tabIndex: number;
    isOpen?: boolean;
    "data-element"?: string;
    onClick: (ev: React.KeyboardEvent<HTMLElement> | React.MouseEvent<HTMLElement>) => void;
    ref: React.RefObject<HTMLButtonElement>;
    "aria-label"?: string;
    id?: string;
    "aria-expanded": boolean;
    "aria-haspopup": "dialog";
}
export declare const renderOpen: ({ tabIndex, onClick, "data-element": dataElement, ref, "aria-label": ariaLabel, id, "aria-expanded": ariaExpanded, "aria-haspopup": ariaHasPopup, }: RenderOpenProps) => React.JSX.Element;
export interface RenderCloseProps {
    "data-element"?: string;
    tabIndex: number;
    onClick: (ev: React.KeyboardEvent<HTMLElement> | React.MouseEvent<HTMLElement>) => void;
    ref: React.RefObject<HTMLButtonElement>;
    "aria-label": string;
    closeButtonDataProps?: Pick<TagProps, "data-role" | "data-element">;
}
export declare const renderClose: ({ "data-element": dataElement, tabIndex, onClick, ref, "aria-label": ariaLabel, closeButtonDataProps, }: RenderCloseProps) => React.JSX.Element;
export interface PopoverContainerProps extends PaddingProps {
    /** A function that will render the open component
     *
     * `({tabIndex, isOpen, data-element, onClick, ref, aria-label}) => ()`
     *
     */
    renderOpenComponent?: (args: RenderOpenProps) => JSX.Element;
    /** A function that will render the close component
     *
     * `({data-element, tabIndex, onClick, ref, aria-label}) => ()`
     *
     */
    renderCloseComponent?: (args: RenderCloseProps) => JSX.Element;
    /** The content of the popover-container */
    children?: React.ReactNode;
    /** Sets rendering position of dialog */
    position?: "left" | "right";
    /** Sets the popover container dialog header name */
    title?: string;
    /** Callback fires when close icon clicked */
    onClose?: (ev: React.KeyboardEvent<HTMLElement> | React.MouseEvent<HTMLElement> | Event) => void;
    /** if `true` the popover-container is open */
    open?: boolean;
    /** Callback fires when open component is clicked */
    onOpen?: (ev: React.KeyboardEvent<HTMLElement> | React.MouseEvent<HTMLElement>) => void;
    /** if `true` the popover-container will cover open button */
    shouldCoverButton?: boolean;
    /** The id of the element that describe the dialog. */
    ariaDescribedBy?: string;
    /** Open button aria label */
    openButtonAriaLabel?: string;
    /** Close button aria label */
    closeButtonAriaLabel?: string;
    /** Data tag prop bag for close Button */
    closeButtonDataProps?: Pick<TagProps, "data-role" | "data-element">;
    /** Container aria label */
    containerAriaLabel?: string;
    /** Disables the animation for the component */
    disableAnimation?: boolean;
}
export declare const PopoverContainer: ({ children, title, position, open, onOpen, onClose, renderOpenComponent, renderCloseComponent, shouldCoverButton, ariaDescribedBy, openButtonAriaLabel, closeButtonAriaLabel, containerAriaLabel, closeButtonDataProps, disableAnimation, ...rest }: PopoverContainerProps) => React.JSX.Element;
export default PopoverContainer;
