function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
import React, { useState, useMemo } from "react";
import PropTypes from "prop-types";
import useLocale from "../../hooks/__internal__/useLocale";
import { StyledBlock, StyledContent, StyledEditAction, StyledActionsContainer, StyledDeleteButton, StyledUndoButton, StyledFooter, StyledPod, StyledHeader, StyledSubtitle, StyledTitle } from "./pod.style";
import Icon from "../icon";
import Event from "../../__internal__/utils/helpers/events";
const Pod = /*#__PURE__*/React.forwardRef(({
  "data-element": dataElement,
  "data-role": dataRole,
  alignTitle = "left",
  border = true,
  children,
  className,
  displayEditButtonOnHover,
  editContentFullWidth,
  footer,
  height,
  internalEditButton,
  onDelete,
  onEdit,
  onUndo,
  size = "medium",
  softDelete,
  subtitle,
  title,
  triggerEditOnContent,
  variant = "primary",
  ...rest
}, ref) => {
  const [isEditFocused, setEditFocused] = useState(false);
  const [isEditHovered, setEditHovered] = useState(false);
  const [isDeleteFocused, setDeleteFocused] = useState(false);
  const [isDeleteHovered, setDeleteHovered] = useState(false);
  const [isUndoFocused, setUndoFocused] = useState(false);
  const [isUndoHovered, setUndoHovered] = useState(false);
  const l = useLocale();
  const shouldContentHaveEditEvents = useMemo(() => !!(onEdit && (triggerEditOnContent || displayEditButtonOnHover)), [displayEditButtonOnHover, onEdit, triggerEditOnContent]);
  const hasButtons = useMemo(() => !!(onEdit || onDelete || onUndo), [onEdit, onDelete, onUndo]);
  const processPodAction = action => ev => {
    if (Event.isKeyboardEvent(ev) && Event.isEventType(ev, "keydown") && !Event.isEnterKey(ev)) return;
    ev.preventDefault();
    action(ev);
  };
  const editEvents = {
    onMouseEnter: () => setEditHovered(true),
    onMouseLeave: () => setEditHovered(false),
    onFocus: () => setEditFocused(true),
    onBlur: () => setEditFocused(false),
    onClick: onEdit && processPodAction(onEdit),
    onKeyDown: onEdit && processPodAction(onEdit)
  };
  return /*#__PURE__*/React.createElement(StyledPod, _extends({
    alignTitle: alignTitle,
    className: className,
    internalEditButton: internalEditButton,
    height: typeof height === "number" ? `${height}px` : height,
    ref: ref,
    "data-component": "pod",
    "data-element": dataElement,
    "data-role": dataRole
  }, rest), /*#__PURE__*/React.createElement(StyledBlock, _extends({
    "data-element": "block",
    contentTriggersEdit: shouldContentHaveEditEvents,
    hasButtons: hasButtons,
    fullWidth: editContentFullWidth,
    internalEditButton: internalEditButton,
    isFocused: isEditFocused || isDeleteFocused,
    isHovered: isEditHovered || isDeleteHovered,
    noBorder: !border,
    variant: variant,
    softDelete: softDelete
  }, shouldContentHaveEditEvents && {
    ...editEvents,
    tabIndex: 0
  }), /*#__PURE__*/React.createElement(StyledContent, {
    "data-element": "content",
    size: size
  }, title && /*#__PURE__*/React.createElement(StyledHeader, {
    alignTitle: alignTitle,
    internalEditButton: internalEditButton,
    size: size
  }, typeof title === "string" ? /*#__PURE__*/React.createElement(StyledTitle, {
    "data-element": "title"
  }, title) : title, typeof subtitle === "string" ? /*#__PURE__*/React.createElement(StyledSubtitle, {
    "data-element": "subtitle"
  }, subtitle) : subtitle), children), footer && /*#__PURE__*/React.createElement(StyledFooter, {
    "data-element": "footer",
    size: size,
    variant: variant,
    softDelete: softDelete
  }, footer)), hasButtons && /*#__PURE__*/React.createElement(StyledActionsContainer, {
    "data-element": "action-button-container",
    internalEditButton: internalEditButton
  }, softDelete && onUndo && /*#__PURE__*/React.createElement(StyledUndoButton, {
    "aria-label": l.pod.undo(),
    onMouseEnter: () => setUndoHovered(true),
    onMouseLeave: () => setUndoHovered(false),
    onFocus: () => setUndoFocused(true),
    onBlur: () => setUndoFocused(false),
    "data-element": "undo",
    internalEditButton: internalEditButton,
    isFocused: isUndoFocused,
    isHovered: isUndoHovered,
    noBorder: !border,
    size: size,
    variant: variant,
    onClick: processPodAction(onUndo)
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "undo"
  })), !softDelete && onEdit && /*#__PURE__*/React.createElement(StyledEditAction, _extends({}, editEvents, {
    "aria-label": l.actions.edit(),
    "data-element": "edit",
    displayOnlyOnHover: displayEditButtonOnHover,
    internalEditButton: internalEditButton,
    isFocused: isEditFocused,
    isHovered: isEditHovered,
    noBorder: !border,
    size: size,
    variant: variant
  }), /*#__PURE__*/React.createElement(Icon, {
    type: "edit"
  })), !softDelete && onDelete && /*#__PURE__*/React.createElement(StyledDeleteButton, {
    "aria-label": l.actions.delete(),
    "data-element": "delete",
    onMouseEnter: () => setDeleteHovered(true),
    onMouseLeave: () => setDeleteHovered(false),
    onFocus: () => setDeleteFocused(true),
    onBlur: () => setDeleteFocused(false),
    internalEditButton: internalEditButton,
    isFocused: isDeleteFocused,
    isHovered: isDeleteHovered,
    noBorder: !border,
    size: size,
    variant: variant,
    onClick: processPodAction(onDelete)
  }, /*#__PURE__*/React.createElement(Icon, {
    type: "delete"
  }))));
});
if (process.env.NODE_ENV !== "production") {
  Pod.propTypes = {
    "alignTitle": PropTypes.oneOf(["center", "left", "right"]),
    "border": PropTypes.bool,
    "children": PropTypes.node,
    "className": PropTypes.string,
    "data-element": PropTypes.string,
    "data-role": PropTypes.string,
    "displayEditButtonOnHover": PropTypes.bool,
    "editContentFullWidth": PropTypes.bool,
    "footer": PropTypes.node,
    "height": PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    "internalEditButton": PropTypes.bool,
    "m": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "margin": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginBottom": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginLeft": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginRight": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginTop": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginX": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "marginY": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mb": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "ml": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mr": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mt": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "mx": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "my": PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.number, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string])), PropTypes.number, PropTypes.object, PropTypes.shape({
      "__@toStringTag": PropTypes.string.isRequired,
      "description": PropTypes.string,
      "toString": PropTypes.func.isRequired,
      "valueOf": PropTypes.func.isRequired
    }), PropTypes.string]),
    "onDelete": PropTypes.func,
    "onEdit": PropTypes.func,
    "onUndo": PropTypes.func,
    "size": PropTypes.oneOf(["extra-large", "extra-small", "large", "medium", "small"]),
    "softDelete": PropTypes.bool,
    "subtitle": PropTypes.node,
    "title": PropTypes.node,
    "triggerEditOnContent": PropTypes.bool,
    "variant": PropTypes.oneOf(["primary", "secondary", "tertiary", "tile", "transparent"])
  };
}
Pod.displayName = "Pod";
export default Pod;