import React from "react";
import { MarginProps } from "styled-system";
import { PodAlignment, PodSize, PodVariant } from "./pod.config";
export interface PodProps extends MarginProps {
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** Aligns the title to left, right or center */
    alignTitle?: PodAlignment;
    /** Enables/disables the border around the pod. */
    border?: boolean;
    /** Children elements */
    children?: React.ReactNode;
    /** Custom className */
    className?: string;
    /** Determines the padding around the pod */
    size?: PodSize;
    /** Prop to apply a theme to the Pod */
    variant?: PodVariant;
    /** Title for the pod */
    title?: React.ReactNode;
    /** Optional subtitle for the pod */
    subtitle?: React.ReactNode;
    /** A component to render as a Pod footer */
    footer?: string | React.ReactNode;
    /** Supplies an edit action to the pod */
    onEdit?: (ev: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>) => void;
    /** Supplies a delete action to the pod */
    onDelete?: (ev: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>) => void;
    /** Supplies an undo action to the pod in soft delete state. */
    onUndo?: (ev: React.MouseEvent<HTMLElement> | React.KeyboardEvent<HTMLElement>) => void;
    /** Sets softboolean; delete state */
    softDelete?: boolean;
    /** Determines if the editable pod content should be full width */
    editContentFullWidth?: boolean;
    /** Determines if the edit button should be hidden until the user hovers over the content */
    displayEditButtonOnHover?: boolean;
    /** Determines if clicking the pod content calls the onEdit action */
    triggerEditOnContent?: boolean;
    /** Sets Pod height, number is changed to pixels and string is passed as raw css value */
    height?: string | number;
    /** Renders edit button inside the pod if it exists. */
    internalEditButton?: boolean;
}
declare const Pod: React.ForwardRefExoticComponent<PodProps & React.RefAttributes<HTMLDivElement>>;
export default Pod;
